/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes;

import com.whitemagicsoftware.keenquotes.Lexeme;
import com.whitemagicsoftware.keenquotes.TokenType;

final class Token
implements Comparable<Token> {
    private final TokenType mType;
    final int mBegan;
    final int mEnded;

    Token(TokenType type, Lexeme lexeme) {
        this(type, lexeme.began(), lexeme.ended());
    }

    Token(TokenType type, int began, int ended) {
        assert (type != null);
        assert (began >= 0);
        assert (ended > began);
        this.mType = type;
        this.mBegan = began;
        this.mEnded = ended;
    }

    TokenType getType() {
        return this.mType;
    }

    int began() {
        return this.mBegan;
    }

    int ended() {
        return this.mEnded;
    }

    @Override
    public int compareTo(Token that) {
        return this.mBegan - that.mBegan;
    }
}

