/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.FontInfo;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.parsers.IndexedLinkedHashSet;
import com.whitemagicsoftware.tex.resources.FontResourceReader;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class DefaultTeXFontParser {
    public static final int MAX_FONT_DESCRIPTIONS = 32;
    public static final String RESOURCE_NAME = "DefaultTeXFont.xml";
    public static final String STYLE_MAPPING_EL = "TextStyleMapping";
    public static final String SYMBOL_MAPPING_EL = "SymbolMapping";
    public static final String GEN_SET_EL = "GeneralSettings";
    public static final String MUFONTID_ATTR = "mufontid";
    public static final String SPACEFONTID_ATTR = "spacefontid";
    private static final IndexedLinkedHashSet<String> mResolvedFontInfo = new IndexedLinkedHashSet();
    private static Map<String, Integer> rangeTypeMappings = new HashMap<String, Integer>();
    private static Map<String, CharChildParser> charChildParsers;
    private Map<String, CharFont[]> parsedTextStyles;
    private Element root = new XMLResourceReader("DefaultTeXFont.xml").read();

    private static int parseFontIdElement(Element element) {
        Element element2;
        return DefaultTeXFontParser.parseFontIdElement("fontId", element2);
    }

    /*
     * WARNING - void declaration
     */
    private static int parseFontIdElement(String attribute, Element element) {
        void var1_1;
        String string = DefaultTeXFontParser.parseStringElement(attribute, (Element)var1_1);
        return mResolvedFontInfo.addIndex(string);
    }

    public DefaultTeXFontParser() throws ResourceParseException {
        this.parsedTextStyles = this.parseStyleMappings();
    }

    /*
     * WARNING - void declaration
     */
    public FontInfo[] parseFontDescriptions() throws ResourceParseException {
        void var1_1;
        Object res = new FontInfo[32];
        Element fontDescriptions = this.root.getChild("FontDescriptions");
        if (fontDescriptions != null) {
            Iterator<Element> iterator;
            for (Element font : ((Element)((Object)iterator)).getChildren("Font")) {
                Iterator<Element> iterator2;
                String name = DefaultTeXFontParser.parseStringElement("name", font);
                int id = DefaultTeXFontParser.parseFontIdElement("id", font);
                float f = DefaultTeXFontParser.parseFloatElement("space", font);
                float xHeight = DefaultTeXFontParser.parseFloatElement("xHeight", font);
                float quad = DefaultTeXFontParser.parseFloatElement("quad", font);
                int skewChar = DefaultTeXFontParser.parseOptionalInt("skewChar", font, -1);
                Font f2 = new FontResourceReader(name).read();
                FontInfo info = new FontInfo(id, f2, xHeight, f, quad);
                if (skewChar != -1) {
                    info.setSkewChar((char)skewChar);
                }
                for (Element object : ((Element)((Object)iterator2)).getChildren("Char")) {
                    FontInfo fontInfo = info;
                    Element element = object;
                    char c = (char)DefaultTeXFontParser.parseIntElement("code", element);
                    float[] fArray = new float[4];
                    Object object2 = fArray;
                    fArray[0] = DefaultTeXFontParser.parseOptionalFloat("width", element, 0.0f);
                    object2[1] = DefaultTeXFontParser.parseOptionalFloat("height", element, 0.0f);
                    object2[2] = DefaultTeXFontParser.parseOptionalFloat("depth", element, 0.0f);
                    object2[3] = DefaultTeXFontParser.parseOptionalFloat("italic", element, 0.0f);
                    fontInfo.setMetrics(c, (float[])object2);
                    for (Element element2 : element.getChildren()) {
                        object2 = element2;
                        String string = element2.getName();
                        CharChildParser charChildParser = charChildParsers.get(string);
                        if (charChildParser == null) {
                            res = String.format("%s: a <Char>-element has unknown child element '%s'", RESOURCE_NAME, string);
                            throw new XMLResourceParseException((String)res);
                        }
                        charChildParser.parse((Element)object2, c, fontInfo);
                    }
                }
                res[id] = info;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, CharFont> parseSymbolMappings() throws ResourceParseException {
        void var2_2;
        Iterator<Element> iterator;
        Element symbolMappings = this.root.getChild("SymbolMappings");
        if (symbolMappings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "SymbolMappings");
        }
        HashMap<String, CharFont> res = new HashMap<String, CharFont>();
        for (Element mapping : ((Element)((Object)iterator)).getChildren(SYMBOL_MAPPING_EL)) {
            void var3_3;
            String symbolName = DefaultTeXFontParser.parseStringElement("name", mapping);
            int ch = DefaultTeXFontParser.parseIntElement("ch", mapping);
            int fontId = DefaultTeXFontParser.parseFontIdElement("fontId", mapping);
            res.put(symbolName, new CharFont((char)ch, (int)var3_3));
        }
        if (res.get("sqrt") == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml: the required mapping <SymbolMap name=\"sqrt\" ... /> is not found!");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String[] parseDefaultTextStyleMappings() throws ResourceParseException {
        void var2_2;
        Iterator<Element> iterator;
        Element defaultTextStyleMappings = this.root.getChild("DefaultTextStyleMapping");
        if (defaultTextStyleMappings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "DefaultTextStyleMapping");
        }
        String[] res = new String[3];
        for (Element mapping : ((Element)((Object)iterator)).getChildren("MapStyle")) {
            void var3_3;
            String code = DefaultTeXFontParser.parseStringElement("code", mapping);
            Integer codeMapping = rangeTypeMappings.get(code);
            if (codeMapping == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "code", "contains an unknown \"range name\" '" + code + "'");
            }
            String textStyleName = DefaultTeXFontParser.parseStringElement("textStyle", mapping);
            CharFont[] charFontArray = this.parsedTextStyles.get(textStyleName);
            if (charFontArray == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "MapStyle", "textStyle", "contains an unknown text style '" + textStyleName + "'");
            }
            charFontArray = this.parsedTextStyles.get(textStyleName);
            if (charFontArray[codeMapping] == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: the default text style mapping '" + textStyleName + "' for the range '" + code + "' contains no mapping for that range!");
            }
            res[codeMapping.intValue()] = var3_3;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Float> parseParameters() throws ResourceParseException {
        void var2_2;
        Element parameters = this.root.getChild("Parameters");
        if (parameters == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "Parameters");
        }
        HashMap<String, Float> res = new HashMap<String, Float>();
        for (Attribute attribute : parameters.getAttributes()) {
            String name;
            String string = name = attribute.getName();
            res.put(string, Float.valueOf(DefaultTeXFontParser.parseFloatElement(string, parameters)));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Number> parseGeneralSettings() throws ResourceParseException {
        void var2_2;
        void var1_1;
        Element generalSettings = this.root.getChild(GEN_SET_EL);
        if (generalSettings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, GEN_SET_EL);
        }
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put(MUFONTID_ATTR, DefaultTeXFontParser.parseFontIdElement(MUFONTID_ATTR, generalSettings));
        result.put(SPACEFONTID_ATTR, DefaultTeXFontParser.parseFontIdElement(SPACEFONTID_ATTR, generalSettings));
        result.put("scriptfactor", Float.valueOf(DefaultTeXFontParser.parseFloatElement("scriptfactor", generalSettings)));
        result.put("scriptscriptfactor", Float.valueOf(DefaultTeXFontParser.parseFloatElement("scriptscriptfactor", (Element)var1_1)));
        return var2_2;
    }

    public Map<String, CharFont[]> getParsedTextStyleMappings() {
        return this.parsedTextStyles;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, CharFont[]> parseStyleMappings() throws ResourceParseException {
        void var2_2;
        Iterator<Element> iterator;
        Element textStyleMappings = this.root.getChild("TextStyleMappings");
        if (textStyleMappings == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, "TextStyleMappings");
        }
        HashMap<String, CharFont[]> res = new HashMap<String, CharFont[]>();
        for (Element mapping : ((Element)((Object)iterator)).getChildren(STYLE_MAPPING_EL)) {
            Iterator iterator2;
            String textStyleName = DefaultTeXFontParser.parseStringElement("name", mapping);
            List<Element> mapRangeList = mapping.getChildren("MapRange");
            CharFont[] charFonts = new CharFont[3];
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Element mapRange;
                Element element = mapRange = (Element)iterator2.next();
                int fontId = DefaultTeXFontParser.parseFontIdElement("fontId", element);
                int ch = DefaultTeXFontParser.parseIntElement("start", mapRange);
                String code = DefaultTeXFontParser.parseStringElement("code", mapRange);
                Integer codeMapping = rangeTypeMappings.get(code);
                if (codeMapping == null) {
                    throw new XMLResourceParseException(RESOURCE_NAME, "MapRange", "code", "contains an unknown \"range name\" '" + code + "'");
                }
                charFonts[codeMapping.intValue()] = new CharFont((char)ch, fontId);
            }
            res.put(textStyleName, charFonts);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float parseFloatElement(String attrName, Element element) throws ResourceParseException {
        void var2_3;
        String attrValue = DefaultTeXFontParser.parseStringElement(attrName, element);
        try {
            float res = (float)Double.parseDouble(attrValue);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            void var1_1;
            throw new XMLResourceParseException(RESOURCE_NAME, var1_1.getName(), string, "has an invalid real value!");
        }
        return (float)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int parseIntElement(String attrName, Element element) throws ResourceParseException {
        void var3_3;
        String attrValue = DefaultTeXFontParser.parseStringElement(attrName, element);
        try {
            int res = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException numberFormatException) {
            void var2_2;
            String string;
            void var1_1;
            throw new XMLResourceParseException(RESOURCE_NAME, var1_1.getName(), string, "must be an integer value, not: '" + (String)var2_2 + "'");
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int parseOptionalInt(String attrName, Element element, int defaultValue) throws ResourceParseException {
        void var2_2;
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            return defaultValue;
        }
        try {
            void var3_3;
            int res = Integer.parseInt((String)var3_3);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            void var1_1;
            throw new XMLResourceParseException(RESOURCE_NAME, var1_1.getName(), string, "has an invalid integer value!");
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float parseOptionalFloat(String attrName, Element element, float defaultValue) throws ResourceParseException {
        void var2_2;
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            return defaultValue;
        }
        try {
            void var3_3;
            float res = (float)Double.parseDouble((String)var3_3);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            void var1_1;
            throw new XMLResourceParseException(RESOURCE_NAME, var1_1.getName(), string, "has an invalid float value!");
        }
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static String parseStringElement(String attrName, Element element) throws ResourceParseException {
        void var2_2;
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            String string;
            void var1_1;
            throw new XMLResourceParseException(RESOURCE_NAME, var1_1.getName(), string, null);
        }
        return var2_2;
    }

    static {
        rangeTypeMappings.put("numbers", 0);
        rangeTypeMappings.put("capitals", 1);
        rangeTypeMappings.put("small", 2);
        rangeTypeMappings.put("unicode", 3);
        charChildParsers = new HashMap<String, CharChildParser>();
        charChildParsers.put("Kern", new KernParser());
        charChildParsers.put("Lig", new LigParser());
        charChildParsers.put("NextLarger", new NextLargerParser());
        charChildParsers.put("Extension", new ExtensionParser());
    }

    static interface CharChildParser {
        public void parse(Element var1, char var2, FontInfo var3) throws XMLResourceParseException;
    }

    static final class KernParser
    implements CharChildParser {
        KernParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            void var1_2;
            void var2_3;
            void var3_4;
            int code = DefaultTeXFontParser.parseIntElement("code", el);
            float kernAmount = DefaultTeXFontParser.parseFloatElement("val", el);
            var3_4.addKern((char)var2_3, (char)code, (float)var1_2);
        }
    }

    static final class LigParser
    implements CharChildParser {
        LigParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            void var1_2;
            void var2_3;
            void var3_4;
            int code = DefaultTeXFontParser.parseIntElement("code", el);
            int ligCode = DefaultTeXFontParser.parseIntElement("ligCode", el);
            var3_4.addLigature((char)var2_3, (char)code, (char)var1_2);
        }
    }

    static final class NextLargerParser
    implements CharChildParser {
        NextLargerParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            void var1_2;
            void var2_3;
            void var3_4;
            int fontId = DefaultTeXFontParser.parseFontIdElement(el);
            int code = DefaultTeXFontParser.parseIntElement("code", el);
            var3_4.setNextLarger((char)var2_3, (char)var1_2, fontId);
        }
    }

    static final class ExtensionParser
    implements CharChildParser {
        ExtensionParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(Element el, char ch, FontInfo info) throws ResourceParseException {
            void var2_2;
            void var3_3;
            void var1_1;
            int[] nArray = new int[4];
            int[] extensionChars = nArray;
            nArray[2] = DefaultTeXFontParser.parseIntElement("rep", el);
            extensionChars[0] = DefaultTeXFontParser.parseOptionalInt("top", el, -1);
            extensionChars[1] = DefaultTeXFontParser.parseOptionalInt("mid", el, -1);
            extensionChars[3] = DefaultTeXFontParser.parseOptionalInt("bot", (Element)var1_1, -1);
            var3_3.setExtension((char)var2_2, extensionChars);
        }
    }
}

