/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import org.jdom2.CDATA;
import org.jdom2.CloneBase;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.ContentList;
import org.jdom2.DocType;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.IllegalAddException;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;

public final class Document
extends CloneBase
implements Parent {
    transient ContentList content = new ContentList(this);

    public Document() {
    }

    /*
     * WARNING - void declaration
     */
    private Document(Element rootElement, DocType docType, String baseURI) {
        if (rootElement != null) {
            void var1_1;
            this.setRootElement((Element)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Document(Element rootElement) {
        this((Element)var1_1, null, null);
        void var1_1;
    }

    public final boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final Element getRootElement() {
        void var1_1;
        int index = this.content.indexOfFirstElement();
        if (index < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Document setRootElement(Element rootElement) {
        int index = this.content.indexOfFirstElement();
        if (index < 0) {
            this.content.add(rootElement);
        } else {
            void var1_1;
            void var2_2;
            this.content.set((int)var2_2, (Content)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final DocType getDocType() {
        void var1_1;
        int index = this.content.indexOfDocType();
        if (index < 0) {
            return null;
        }
        return (DocType)this.content.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        Element rootElement;
        StringBuilder stringForm = new StringBuilder("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringForm.append(docType.toString()).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        if ((rootElement = this.hasRootElement() ? this.getRootElement() : null) != null) {
            void var2_2;
            stringForm.append("Root is ").append(var2_2.toString());
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return var1_1.toString();
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private Document clone() {
        void var1_1;
        Document doc = (Document)super.clone();
        ((Document)super.clone()).content = new ContentList(doc);
        for (int i = 0; i < this.content.size(); ++i) {
            void var3_3;
            ProcessingInstruction pi;
            Comment comment;
            Element element;
            Content obj = this.content.get(i);
            if (obj instanceof Element) {
                element = ((Element)obj).clone();
                doc.content.add(element);
                continue;
            }
            if (element instanceof Comment) {
                comment = ((Comment)((Object)element)).clone();
                doc.content.add(comment);
                continue;
            }
            if (comment instanceof ProcessingInstruction) {
                pi = ((ProcessingInstruction)((Object)comment)).clone();
                doc.content.add(pi);
                continue;
            }
            if (!(pi instanceof DocType)) continue;
            DocType dt = ((DocType)((Object)pi)).clone();
            doc.content.add(var3_3);
        }
        return var1_1;
    }

    public final Parent getParent() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void canContainContent(Content child, int index, boolean replace) {
        void var1_1;
        if (child instanceof Element) {
            int cre = this.content.indexOfFirstElement();
            if (replace && cre == index) {
                return;
            }
            if (cre >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (this.content.indexOfDocType() >= index) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (child instanceof DocType) {
            void var2_2;
            void var3_3;
            int cdt = this.content.indexOfDocType();
            if (replace && cdt == index) {
                return;
            }
            if (cdt >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int firstElt = this.content.indexOfFirstElement();
            if (firstElt != -1 && var3_3 < var2_2) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (child instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (child instanceof Text) {
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (var1_1 instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }
}

