/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.IllegalAddException;
import org.jdom2.IllegalNameException;
import org.jdom2.Verifier;
import org.jdom2.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessingInstruction
extends Content {
    private String target;
    private String rawData;

    protected ProcessingInstruction() {
        super(Content.CType.ProcessingInstruction);
    }

    /*
     * WARNING - void declaration
     */
    public ProcessingInstruction(String target, String data) {
        super(Content.CType.ProcessingInstruction);
        void var2_2;
        ProcessingInstruction processingInstruction;
        void var3_3 = processingInstruction;
        processingInstruction = this;
        String string = Verifier.checkProcessingInstructionTarget((String)var3_3);
        if (string != null) {
            throw new IllegalNameException((String)var3_3, string);
        }
        processingInstruction.target = var3_3;
        var3_3 = var2_2;
        processingInstruction = this;
        string = Verifier.checkProcessingInstructionData((String)var3_3);
        if (string != null) {
            throw new IllegalAddException((String)var3_3, string);
        }
        processingInstruction.rawData = var3_3;
        ProcessingInstruction.parseData((String)var3_3);
    }

    public final String getTarget() {
        return this.target;
    }

    public final String getData() {
        return this.rawData;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> parseData(String prawData) {
        void var1_1;
        LinkedHashMap<void, void> data = new LinkedHashMap<void, void>();
        String inputData = prawData.trim();
        while (!inputData.trim().equals("")) {
            void var3_3;
            void var2_2;
            int pos;
            String name = "";
            String value = "";
            int startName = 0;
            char previousChar = inputData.charAt(0);
            for (pos = 1; pos < inputData.length(); ++pos) {
                char currentChar = inputData.charAt(pos);
                if (currentChar == '=') {
                    name = inputData.substring(startName, pos).trim();
                    int[] bounds = ProcessingInstruction.extractQuotedString(inputData.substring(pos + 1));
                    if (bounds == null) {
                        return Collections.emptyMap();
                    }
                    value = inputData.substring(bounds[0] + pos + 1, bounds[1] + pos + 1);
                    pos += bounds[1] + 1;
                    break;
                }
                if (Character.isWhitespace(previousChar) && !Character.isWhitespace(currentChar)) {
                    int n = pos;
                }
                previousChar = currentChar;
            }
            inputData = inputData.substring(pos);
            if (name.length() <= 0) continue;
            data.put(var2_2, var3_3);
        }
        return var1_1;
    }

    private static int[] extractQuotedString(String rawData) {
        boolean inQuotes = false;
        char quoteChar = '\"';
        int start = 0;
        for (int pos = 0; pos < rawData.length(); ++pos) {
            char currentChar = rawData.charAt(pos);
            if (currentChar != '\"' && currentChar != '\'') continue;
            if (!inQuotes) {
                quoteChar = currentChar;
                inQuotes = true;
                start = pos + 1;
                continue;
            }
            if (quoteChar != currentChar) continue;
            return new int[]{start, pos};
        }
        return null;
    }

    public final String toString() {
        return "[ProcessingInstruction: " + new XMLOutputter().outputString(this) + "]";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ProcessingInstruction clone() {
        void var1_1;
        ProcessingInstruction pi = (ProcessingInstruction)super.clone();
        ProcessingInstruction.parseData(this.rawData);
        return var1_1;
    }
}

