/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

import com.whitemagicsoftware.keenquotes.lex.Lexeme;
import com.whitemagicsoftware.keenquotes.lex.LexemeType;
import com.whitemagicsoftware.keenquotes.lex.Lexer;
import com.whitemagicsoftware.keenquotes.lex.LexerFilter;
import com.whitemagicsoftware.keenquotes.parser.Contractions;
import com.whitemagicsoftware.keenquotes.parser.Token;
import com.whitemagicsoftware.keenquotes.parser.TokenType;
import com.whitemagicsoftware.keenquotes.util.CircularFifoQueue;
import java.util.function.Consumer;

public final class QuoteEmitter
implements Consumer<Lexeme> {
    private static final LexemeType[] WORD_PERIOD_NUMBER = new LexemeType[]{LexemeType.WORD, LexemeType.PERIOD, LexemeType.NUMBER};
    private static final LexemeType[] PUNCT_PERIOD_ELLIPSIS_DASH = new LexemeType[]{LexemeType.PUNCT, LexemeType.PERIOD, LexemeType.ELLIPSIS, LexemeType.DASH};
    private static final LexemeType[] PUNCT_PERIOD = new LexemeType[]{LexemeType.PUNCT, LexemeType.PERIOD};
    private static final LexemeType[] SPACE_DASH_ENDING = new LexemeType[]{LexemeType.SPACE, LexemeType.DASH, LexemeType.ENDING};
    private static final LexemeType[] SPACE_ENDING = new LexemeType[]{LexemeType.SPACE, LexemeType.ENDING};
    private static final LexemeType[] SPACE_HYPHEN = new LexemeType[]{LexemeType.SPACE, LexemeType.HYPHEN};
    private static final LexemeType[] SPACE_PUNCT = new LexemeType[]{LexemeType.SPACE, LexemeType.PUNCT};
    private static final LexemeType[] SPACE_SOT = new LexemeType[]{LexemeType.SPACE, LexemeType.SOT};
    private static final LexemeType[] QUOTE_SINGLE_QUOTE_DOUBLE = new LexemeType[]{LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE};
    private static final LexemeType[] LEADING_QUOTE_OPENING_SINGLE = new LexemeType[]{LexemeType.SOT, LexemeType.SPACE, LexemeType.DASH, LexemeType.QUOTE_DOUBLE, LexemeType.OPENING_GROUP, LexemeType.EOL, LexemeType.EOP};
    private static final LexemeType[] LAGGING_QUOTE_OPENING_SINGLE = new LexemeType[]{LexemeType.WORD, LexemeType.ELLIPSIS, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE};
    private static final LexemeType[] LEADING_QUOTE_CLOSING_SINGLE = new LexemeType[]{LexemeType.WORD, LexemeType.NUMBER, LexemeType.PERIOD, LexemeType.PUNCT, LexemeType.ELLIPSIS, LexemeType.QUOTE_DOUBLE};
    private static final LexemeType[] LAGGING_QUOTE_CLOSING_SINGLE = new LexemeType[]{LexemeType.SPACE, LexemeType.HYPHEN, LexemeType.DASH, LexemeType.PUNCT, LexemeType.PERIOD, LexemeType.ELLIPSIS, LexemeType.QUOTE_DOUBLE, LexemeType.CLOSING_GROUP, LexemeType.ENDING};
    private static final LexemeType[] LEADING_QUOTE_OPENING_DOUBLE = new LexemeType[]{LexemeType.SOT, LexemeType.SPACE, LexemeType.DASH, LexemeType.EQUALS, LexemeType.QUOTE_SINGLE, LexemeType.OPENING_GROUP, LexemeType.EOL, LexemeType.EOP};
    private static final LexemeType[] LAGGING_QUOTE_OPENING_DOUBLE = new LexemeType[]{LexemeType.WORD, LexemeType.NUMBER, LexemeType.DASH, LexemeType.ELLIPSIS, LexemeType.OPENING_GROUP, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_SINGLE_OPENING, LexemeType.QUOTE_SINGLE_CLOSING, LexemeType.QUOTE_DOUBLE};
    private static final LexemeType[] LEADING_QUOTE_CLOSING_DOUBLE = new LexemeType[]{LexemeType.WORD, LexemeType.NUMBER, LexemeType.PERIOD, LexemeType.PUNCT, LexemeType.DASH, LexemeType.ELLIPSIS, LexemeType.CLOSING_GROUP, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_SINGLE_CLOSING, LexemeType.QUOTE_SINGLE_OPENING};
    private static final LexemeType[] LAGGING_QUOTE_CLOSING_DOUBLE = new LexemeType[]{LexemeType.SPACE, LexemeType.PUNCT, LexemeType.PERIOD, LexemeType.EQUALS, LexemeType.HYPHEN, LexemeType.DASH, LexemeType.QUOTE_SINGLE, LexemeType.CLOSING_GROUP, LexemeType.ENDING};
    private final CircularFifoQueue<Lexeme> mQ = new CircularFifoQueue(4);
    private final String mText;
    private final Contractions mContractions;
    private final Consumer<Token> mConsumer;

    public QuoteEmitter(String text, Contractions contractions, Consumer<Token> consumer) {
        assert (text != null);
        assert (contractions != null);
        this.mText = text;
        this.mContractions = contractions;
        this.mConsumer = consumer;
    }

    public static void analyze(String text, Contractions contractions, Consumer<Token> consumer, LexerFilter filter) {
        QuoteEmitter emitter = new QuoteEmitter(text, contractions, consumer);
        Lexer.lex(text, (Consumer<Lexeme>)emitter, filter);
    }

    @Override
    public void accept(Lexeme lexeme) {
        this.mQ.add(lexeme);
        if (this.mQ.size() == 4) {
            this.parse();
        }
    }

    private void parse() {
        Lexeme lex1 = this.mQ.get(0);
        Lexeme lex2 = this.mQ.get(1);
        Lexeme lex3 = this.mQ.get(2);
        Lexeme lex4 = this.mQ.get(3);
        if (this.match(WORD_PERIOD_NUMBER, LexemeType.QUOTE_SINGLE, LexemeType.WORD, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
        } else if (this.match(LexemeType.ANY, LexemeType.QUOTE_SINGLE, LexemeType.WORD, LexemeType.QUOTE_SINGLE) && this.mContractions.beganEndedUmambiguously(lex3.toString(this.mText))) {
            this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
            this.emit(TokenType.QUOTE_APOSTROPHE, lex4);
            this.mQ.set(Lexeme.NONE, 3);
        } else if (this.match(LexemeType.NUMBER, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_SINGLE, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_PRIME_DOUBLE, lex2.began(), lex3.ended());
            this.mQ.set(Lexeme.NONE, 2);
        } else if (this.match(LexemeType.NUMBER, LexemeType.QUOTE_SINGLE, LexemeType.ANY, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_PRIME_SINGLE, lex2);
        } else if (this.match(LexemeType.NUMBER, LexemeType.QUOTE_DOUBLE, LexemeType.ANY, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_PRIME_DOUBLE, lex2);
        } else if (this.match(LexemeType.WORD, LexemeType.QUOTE_SINGLE, LexemeType.ANY, LexemeType.ANY) && this.mContractions.endedUnambiguously(lex1.toString(this.mText))) {
            this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
        } else if (this.match(LexemeType.ANY, LexemeType.QUOTE_SINGLE, LexemeType.NUMBER, SPACE_PUNCT)) {
            this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
        } else if (this.match(LexemeType.ANY, LexemeType.QUOTE_SINGLE, LexemeType.NUMBER, LexemeType.WORD) && "s".equalsIgnoreCase(lex4.toString(this.mText))) {
            this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
        } else if (this.match(PUNCT_PERIOD_ELLIPSIS_DASH, LexemeType.QUOTE_SINGLE, LexemeType.ENDING, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_CLOSING_SINGLE, lex2);
        } else if (this.match(LexemeType.ESC_SINGLE, LexemeType.ANY, LexemeType.ANY, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_STRAIGHT_SINGLE, lex1);
        } else if (this.match(LexemeType.ESC_DOUBLE, LexemeType.ANY, LexemeType.ANY, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_STRAIGHT_DOUBLE, lex1);
            if (this.match(LexemeType.ESC_DOUBLE, LexemeType.QUOTE_SINGLE, SPACE_DASH_ENDING, LexemeType.ANY)) {
                this.emit(TokenType.QUOTE_CLOSING_SINGLE, lex2);
            }
        } else if (this.match(LexemeType.DASH, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE, SPACE_ENDING)) {
            this.emit(TokenType.QUOTE_CLOSING_SINGLE, lex2);
        } else if (this.match(LexemeType.WORD, LexemeType.QUOTE_SINGLE, SPACE_HYPHEN, LexemeType.WORD) && "o".equalsIgnoreCase(lex1.toString(this.mText))) {
            this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
        } else if (this.match(LEADING_QUOTE_OPENING_DOUBLE, LexemeType.QUOTE_DOUBLE, LAGGING_QUOTE_OPENING_DOUBLE, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_OPENING_DOUBLE, lex2);
        } else if (this.match(LEADING_QUOTE_CLOSING_DOUBLE, LexemeType.QUOTE_DOUBLE, LAGGING_QUOTE_CLOSING_DOUBLE, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_CLOSING_DOUBLE, lex2);
        } else if (this.match(SPACE_SOT, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_SINGLE, LexemeType.WORD)) {
            this.emit(TokenType.QUOTE_OPENING_SINGLE, lex2);
            this.emit(TokenType.QUOTE_APOSTROPHE, lex3);
            this.mQ.set(Lexeme.NONE, 1);
            this.mQ.set(Lexeme.NONE, 2);
        } else if (this.match(LEADING_QUOTE_OPENING_SINGLE, LexemeType.QUOTE_SINGLE, LAGGING_QUOTE_OPENING_SINGLE, LexemeType.ANY)) {
            String word = lex3.toString(this.mText);
            if (this.mContractions.beganAmbiguously(word)) {
                this.emit(TokenType.QUOTE_AMBIGUOUS_LEADING, lex2);
            } else if (this.mContractions.beganUnambiguously(word)) {
                this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
            } else if (this.match(LexemeType.QUOTE_DOUBLE, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE, LexemeType.WORD)) {
                this.emit(TokenType.QUOTE_OPENING_SINGLE, lex2);
            } else if (this.match(LexemeType.QUOTE_DOUBLE, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE, LexemeType.ANY)) {
                this.emit(lex2);
            } else if (this.match(LexemeType.ANY, LexemeType.QUOTE_SINGLE, LAGGING_QUOTE_OPENING_SINGLE, LexemeType.ANY)) {
                this.emit(TokenType.QUOTE_OPENING_SINGLE, lex2);
            } else {
                this.emit(TokenType.QUOTE_AMBIGUOUS_LEADING, lex2);
            }
        } else if (this.match(LEADING_QUOTE_CLOSING_SINGLE, LexemeType.QUOTE_SINGLE, LAGGING_QUOTE_CLOSING_SINGLE, LexemeType.ANY)) {
            String word = lex1.toString(this.mText);
            if (this.mContractions.endedAmbiguously(word)) {
                this.emit(TokenType.QUOTE_AMBIGUOUS_LAGGING, lex2);
            } else {
                this.emit(TokenType.QUOTE_CLOSING_SINGLE, lex2);
            }
        } else if (this.match(LexemeType.WORD, LexemeType.QUOTE_SINGLE, PUNCT_PERIOD, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
        } else if (this.match(LexemeType.DASH, LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_DOUBLE, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_CLOSING_SINGLE, lex2);
        } else if (this.match(LexemeType.ANY, LexemeType.QUOTE_SINGLE, LexemeType.NUMBER, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_OPENING_SINGLE, lex2);
        } else if (this.match(LexemeType.NONE, LexemeType.QUOTE_SINGLE, LexemeType.ANY, LexemeType.ANY)) {
            this.emit(TokenType.QUOTE_CLOSING_SINGLE, lex2);
        } else if (this.match(LexemeType.QUOTE_SINGLE, LexemeType.QUOTE_SINGLE, LexemeType.WORD, LexemeType.ANY)) {
            String word = lex3.toString(this.mText);
            if (this.mContractions.beganAmbiguously(word)) {
                this.emit(TokenType.QUOTE_AMBIGUOUS_LEADING, lex2);
            } else if (this.mContractions.beganUnambiguously(word)) {
                this.emit(TokenType.QUOTE_APOSTROPHE, lex2);
            } else {
                this.emit(lex2);
            }
        } else if (this.match(LexemeType.ANY, QUOTE_SINGLE_QUOTE_DOUBLE, LexemeType.ANY, LexemeType.ANY)) {
            this.emit(lex2);
        }
    }

    private void emit(TokenType tokenType, Lexeme lexeme) {
        this.mConsumer.accept(new Token(tokenType, lexeme));
    }

    private void emit(TokenType tokenType, int began, int ended) {
        this.mConsumer.accept(new Token(tokenType, began, ended));
    }

    private void emit(Lexeme lexeme) {
        this.mConsumer.accept(new Token(TokenType.AMBIGUOUS, lexeme));
    }

    private boolean match(LexemeType l1, LexemeType l2, LexemeType l3, LexemeType l4) {
        return this.mQ.get(0).isType(l1) && this.mQ.get(1).isType(l2) && this.mQ.get(2).isType(l3) && this.mQ.get(3).isType(l4);
    }

    private boolean match(LexemeType[] l1, LexemeType l2, LexemeType l3, LexemeType l4) {
        return this.mQ.get(0).isType(l1) && this.mQ.get(1).isType(l2) && this.mQ.get(2).isType(l3) && this.mQ.get(3).isType(l4);
    }

    private boolean match(LexemeType l1, LexemeType[] l2, LexemeType l3, LexemeType l4) {
        return this.mQ.get(0).isType(l1) && this.mQ.get(1).isType(l2) && this.mQ.get(2).isType(l3) && this.mQ.get(3).isType(l4);
    }

    private boolean match(LexemeType l1, LexemeType l2, LexemeType[] l3, LexemeType l4) {
        return this.mQ.get(0).isType(l1) && this.mQ.get(1).isType(l2) && this.mQ.get(2).isType(l3) && this.mQ.get(3).isType(l4);
    }

    private boolean match(LexemeType l1, LexemeType l2, LexemeType l3, LexemeType[] l4) {
        return this.mQ.get(0).isType(l1) && this.mQ.get(1).isType(l2) && this.mQ.get(2).isType(l3) && this.mQ.get(3).isType(l4);
    }

    private boolean match(LexemeType[] l1, LexemeType l2, LexemeType[] l3, LexemeType l4) {
        return this.mQ.get(0).isType(l1) && this.mQ.get(1).isType(l2) && this.mQ.get(2).isType(l3) && this.mQ.get(3).isType(l4);
    }
}

