/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.Locale;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.WordSegmenter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.SegmentingTokenizerBase;
import org.apache.lucene.util.AttributeFactory;

public final class HMMChineseTokenizer
extends SegmentingTokenizerBase {
    private static final BreakIterator sentenceProto = BreakIterator.getSentenceInstance(Locale.ROOT);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final WordSegmenter wordSegmenter = new WordSegmenter();
    private Iterator<WordlistLoader> tokens;

    public HMMChineseTokenizer() {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
    }

    /*
     * WARNING - void declaration
     */
    private HMMChineseTokenizer(AttributeFactory factory) {
        super((AttributeFactory)var1_1, (BreakIterator)sentenceProto.clone());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void setNextSentence(int sentenceStart, int sentenceEnd) {
        void var1_1;
        void var2_3;
        String sentence = new String(this.buffer, sentenceStart, sentenceEnd - sentenceStart);
        this.tokens = this.wordSegmenter.segmentSentence((String)var2_3, this.offset + var1_1).iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean incrementWord() {
        void var1_1;
        if (this.tokens == null || !this.tokens.hasNext()) {
            return false;
        }
        WordlistLoader token = this.tokens.next();
        this.clearAttributes();
        this.termAtt.copyBuffer(token.charArray, 0, token.charArray.length);
        this.offsetAtt.setOffset(this.correctOffset(token.startOffset), this.correctOffset(var1_1.endOffset));
        this.typeAtt.setType("word");
        return true;
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.tokens = null;
    }
}

