/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ko.KoreanPartOfSpeechStopFilter;
import org.apache.lucene.analysis.ko.KoreanReadingFormFilter;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.UserDictionary;

public class KoreanAnalyzer
extends Analyzer {
    private final UserDictionary userDict;
    private final KoreanTokenizer.DecompoundMode mode;
    private final Set<POS.Tag> stopTags;
    private final boolean outputUnknownUnigrams;

    public KoreanAnalyzer() {
        this(null, KoreanTokenizer.DEFAULT_DECOMPOUND, KoreanPartOfSpeechStopFilter.DEFAULT_STOP_TAGS, false);
    }

    /*
     * WARNING - void declaration
     */
    private KoreanAnalyzer(UserDictionary userDict, KoreanTokenizer.DecompoundMode mode, Set<POS.Tag> stopTags, boolean outputUnknownUnigrams) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.userDict = var1_1;
        this.mode = var2_2;
        this.stopTags = var3_3;
        this.outputUnknownUnigrams = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Analyzer.TokenStreamComponents createComponents$2e873add() {
        void var2_2;
        void var1_1;
        KoreanTokenizer tokenizer = new KoreanTokenizer(TokenStream.DEFAULT_TOKEN_ATTRIBUTE_FACTORY, this.userDict, this.mode, this.outputUnknownUnigrams);
        TokenFilter stream = new KoreanPartOfSpeechStopFilter(tokenizer, this.stopTags);
        stream = new KoreanReadingFormFilter(stream);
        stream = new LowerCaseFilter(stream);
        return new Analyzer.TokenStreamComponents((Tokenizer)var1_1, (TokenStream)var2_2);
    }
}

