/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;

public abstract class BinaryDictionary
implements Dictionary {
    private final ResourceScheme resourceScheme;
    private final String resourcePath;
    private final ByteBuffer buffer;
    private final int[] targetMapOffsets;
    private final int[] targetMap;
    private final POS.Tag[] posDict;

    protected BinaryDictionary() throws IOException {
        this(ResourceScheme.CLASSPATH, null);
    }

    /*
     * WARNING - void declaration
     */
    protected BinaryDictionary(ResourceScheme resourceScheme, String resourcePath) throws IOException {
        ByteBuffer buffer;
        int[] targetMap;
        this.resourceScheme = resourceScheme;
        if (resourcePath == null) {
            if (resourceScheme != ResourceScheme.CLASSPATH) {
                throw new IllegalArgumentException("resourcePath must be supplied with FILE resource scheme");
            }
            this.resourcePath = this.getClass().getName().replace('.', '/');
        } else {
            this.resourcePath = resourcePath;
        }
        InputStream mapIS = null;
        InputStream dictIS = null;
        InputStream posIS = null;
        try {
            mapIS = this.getResource("$targetMap.dat");
            mapIS = new BufferedInputStream(mapIS);
            InputStreamDataInput in = new InputStreamDataInput(mapIS);
            CodecUtil.checkHeader(in, "ko_dict_map", 1, 1);
            targetMap = new int[in.readVInt()];
            int[] targetMapOffsets = new int[in.readVInt()];
            int accum = 0;
            int sourceId = 0;
            for (int ofs = 0; ofs < targetMap.length; ++ofs) {
                int val = in.readVInt();
                if ((val & 1) != 0) {
                    targetMapOffsets[sourceId] = ofs;
                    ++sourceId;
                }
                targetMap[ofs] = accum += val >>> 1;
            }
            if (sourceId + 1 != targetMapOffsets.length) {
                throw new IOException("targetMap file format broken; targetMap.length=" + targetMap.length + ", targetMapOffsets.length=" + targetMapOffsets.length + ", sourceId=" + sourceId);
            }
            targetMapOffsets[sourceId] = targetMap.length;
            mapIS.close();
            mapIS = null;
            posIS = this.getResource("$posDict.dat");
            posIS = new BufferedInputStream(posIS);
            in = new InputStreamDataInput(posIS);
            CodecUtil.checkHeader(in, "ko_dict_pos", 1, 1);
            int posSize = in.readVInt();
            this.posDict = new POS.Tag[posSize];
            for (int j = 0; j < posSize; ++j) {
                this.posDict[j] = POS.resolveTag(((DataInput)in).readByte());
            }
            posIS.close();
            posIS = null;
            dictIS = this.getResource("$buffer.dat");
            in = new InputStreamDataInput(dictIS);
            CodecUtil.checkHeader(in, "ko_dict", 1, 1);
            int size = in.readVInt();
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size);
            ReadableByteChannel readableByteChannel = Channels.newChannel(dictIS);
            int n = readableByteChannel.read(tmpBuffer);
            if (n != size) {
                throw new EOFException("Cannot read whole dictionary");
            }
            dictIS.close();
            dictIS = null;
            buffer = tmpBuffer.asReadOnlyBuffer();
        }
        catch (Throwable targetMapOffsets) {
            void var2_2;
            void var3_3;
            void var1_1;
            IOUtils.closeWhileHandlingException(new Closeable[]{var1_1, var3_3, var2_2});
            throw targetMapOffsets;
        }
        IOUtils.closeWhileHandlingException(mapIS, posIS, dictIS);
        this.targetMap = targetMap;
        this.targetMapOffsets = targetMapOffsets;
        this.buffer = buffer;
    }

    /*
     * WARNING - void declaration
     */
    protected final InputStream getResource(String suffix) throws IOException {
        switch (this.resourceScheme) {
            case CLASSPATH: {
                return BinaryDictionary.getClassResource(this.resourcePath + suffix);
            }
            case FILE: {
                void var1_1;
                return Files.newInputStream(Paths.get(this.resourcePath + (String)var1_1, new String[0]), new OpenOption[0]);
            }
        }
        throw new IllegalStateException("unknown resource scheme " + this.resourceScheme);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getResource(ResourceScheme scheme, String path) throws IOException {
        ResourceScheme resourceScheme;
        switch (scheme) {
            case CLASSPATH: {
                return BinaryDictionary.getClassResource(path);
            }
            case FILE: {
                void var1_1;
                return Files.newInputStream(Paths.get((String)var1_1, new String[0]), new OpenOption[0]);
            }
        }
        throw new IllegalStateException("unknown resource scheme " + resourceScheme);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getClassResource(Class<?> clazz, String suffix) throws IOException {
        void var2_2;
        Class<?> clazz2 = clazz;
        InputStream is = clazz2.getResourceAsStream(clazz2.getSimpleName() + suffix);
        if (is == null) {
            void var1_1;
            Class<?> clazz3;
            throw new FileNotFoundException("Not in classpath: " + clazz3.getName().replace('.', '/') + (String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static InputStream getClassResource(String path) throws IOException {
        void var1_1;
        InputStream is = BinaryDictionary.class.getClassLoader().getResourceAsStream(path);
        if (is == null) {
            String string;
            throw new FileNotFoundException("Not in classpath: " + string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void lookupWordIds(int sourceId, IntsRef ref) {
        void var2_2;
        void var1_1;
        ref.ints = this.targetMap;
        ref.offset = this.targetMapOffsets[sourceId];
        ref.length = this.targetMapOffsets[var1_1 + true] - var2_2.offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getLeftId(int wordId) {
        void var1_1;
        return this.buffer.getShort((int)var1_1) >>> 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRightId(int wordId) {
        void var1_1;
        return this.buffer.getShort((int)(var1_1 + 2)) >>> 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getWordCost(int wordId) {
        void var1_1;
        return this.buffer.getShort((int)(var1_1 + 4));
    }

    @Override
    public final POS.Type getPOSType(int wordId) {
        byte by;
        by = (byte)(this.buffer.getShort(by) & 3);
        return POS.resolveType(by);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final POS.Tag getLeftPOS(int wordId) {
        void var1_1;
        return this.posDict[this.getLeftId((int)var1_1)];
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes$7615832f(int wordId, char[] surfaceForm, int off) {
        POS.Type posType = this.getPOSType(wordId);
        if (posType == POS.Type.MORPHEME) {
            return null;
        }
        int offset = wordId + 6;
        int n = wordId;
        BinaryDictionary binaryDictionary = this;
        boolean hasSinglePos = (binaryDictionary.buffer.getShort(n + 2) & 1) != 0;
        if (!hasSinglePos) {
            // empty if block
        }
        int n2 = ++offset;
        ++offset;
        int length = this.buffer.get(n2);
        if (length == 0) {
            return null;
        }
        Dictionary.Morpheme[] morphemes = new Dictionary.Morpheme[length];
        int surfaceOffset = 0;
        POS.Tag leftPOS = this.getLeftPOS(wordId);
        for (int i = 0; i < length; ++i) {
            String form;
            POS.Tag tag;
            POS.Tag tag2 = tag = hasSinglePos ? leftPOS : POS.resolveTag(this.buffer.get(offset++));
            if (posType == POS.Type.INFLECT) {
                n = offset;
                binaryDictionary = this;
                int n3 = binaryDictionary.buffer.get(n++);
                char[] cArray = new char[n3];
                for (int j = 0; j < n3; ++j) {
                    cArray[j] = binaryDictionary.buffer.getChar(n + (j << 1));
                }
                form = new String(cArray);
                offset += (form.length() << 1) + 1;
            } else {
                byte formLen = this.buffer.get(offset++);
                form = new String(surfaceForm, off + surfaceOffset, (int)formLen);
                surfaceOffset += formLen;
            }
            morphemes[i] = new Dictionary.Morpheme(tag, form);
        }
        return morphemes;
    }

    public static final class ResourceScheme
    extends Enum<ResourceScheme> {
        public static final /* enum */ ResourceScheme CLASSPATH = new ResourceScheme();
        public static final /* enum */ ResourceScheme FILE = new ResourceScheme();
        private static final /* synthetic */ ResourceScheme[] $VALUES;

        public static ResourceScheme[] values() {
            return (ResourceScheme[])$VALUES.clone();
        }

        static {
            $VALUES = new ResourceScheme[]{CLASSPATH, FILE};
        }
    }
}

