/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;

public final class CharacterDefinition {
    private static int CLASS_COUNT = CharacterClass.values().length;
    private final byte[] characterCategoryMap = new byte[65536];
    private final boolean[] invokeMap = new boolean[CLASS_COUNT];
    private final boolean[] groupMap = new boolean[CLASS_COUNT];
    public static final byte NGRAM = (byte)CharacterClass.NGRAM.ordinal();

    /*
     * WARNING - void declaration
     */
    private CharacterDefinition() throws IOException {
        InputStream is = null;
        try {
            is = BinaryDictionary.getClassResource(this.getClass(), ".dat");
            is = new BufferedInputStream(is);
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, "ko_cd", 1, 1);
            ((DataInput)in).readBytes(this.characterCategoryMap, 0, this.characterCategoryMap.length);
            for (int i = 0; i < CLASS_COUNT; ++i) {
                byte b = ((DataInput)in).readByte();
                this.invokeMap[i] = (b & 1) != 0;
                this.groupMap[i] = (b & 2) != 0;
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            IOUtils.closeWhileHandlingException(new Closeable[]{var1_1});
            throw throwable;
        }
        IOUtils.close(is);
    }

    /*
     * WARNING - void declaration
     */
    public final byte getCharacterClass(char c) {
        void var1_1;
        return this.characterCategoryMap[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInvoke(char c) {
        void var1_1;
        return this.invokeMap[this.characterCategoryMap[var1_1]];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isGroup(char c) {
        void var1_1;
        return this.groupMap[this.characterCategoryMap[var1_1]];
    }

    public static CharacterDefinition getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static {
        CharacterClass.DEFAULT.ordinal();
        CharacterClass.SPACE.ordinal();
        CharacterClass.SYMBOL.ordinal();
        CharacterClass.NUMERIC.ordinal();
        CharacterClass.ALPHA.ordinal();
        CharacterClass.CYRILLIC.ordinal();
        CharacterClass.GREEK.ordinal();
        CharacterClass.HIRAGANA.ordinal();
        CharacterClass.KATAKANA.ordinal();
        CharacterClass.KANJI.ordinal();
        CharacterClass.HANGUL.ordinal();
        CharacterClass.HANJA.ordinal();
        CharacterClass.HANJANUMERIC.ordinal();
    }

    static final class SingletonHolder {
        static final CharacterDefinition INSTANCE;

        /*
         * WARNING - void declaration
         */
        static {
            try {
                INSTANCE = new CharacterDefinition();
                return;
            }
            catch (IOException ioe) {
                void var0;
                throw new RuntimeException("Cannot load CharacterDefinition.", (Throwable)var0);
            }
        }
    }

    static final class CharacterClass
    extends Enum<CharacterClass> {
        public static final /* enum */ CharacterClass NGRAM = new CharacterClass();
        public static final /* enum */ CharacterClass DEFAULT = new CharacterClass();
        public static final /* enum */ CharacterClass SPACE = new CharacterClass();
        public static final /* enum */ CharacterClass SYMBOL = new CharacterClass();
        public static final /* enum */ CharacterClass NUMERIC = new CharacterClass();
        public static final /* enum */ CharacterClass ALPHA = new CharacterClass();
        public static final /* enum */ CharacterClass CYRILLIC = new CharacterClass();
        public static final /* enum */ CharacterClass GREEK = new CharacterClass();
        public static final /* enum */ CharacterClass HIRAGANA = new CharacterClass();
        public static final /* enum */ CharacterClass KATAKANA = new CharacterClass();
        public static final /* enum */ CharacterClass KANJI = new CharacterClass();
        public static final /* enum */ CharacterClass HANGUL = new CharacterClass();
        public static final /* enum */ CharacterClass HANJA = new CharacterClass();
        public static final /* enum */ CharacterClass HANJANUMERIC = new CharacterClass();
        private static final /* synthetic */ CharacterClass[] $VALUES;

        public static CharacterClass[] values() {
            return (CharacterClass[])$VALUES.clone();
        }

        static {
            $VALUES = new CharacterClass[]{NGRAM, DEFAULT, SPACE, SYMBOL, NUMERIC, ALPHA, CYRILLIC, GREEK, HIRAGANA, KATAKANA, KANJI, HANGUL, HANJA, HANJANUMERIC};
        }
    }
}

