/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

import com.whitemagicsoftware.keenquotes.lex.Lexeme;
import com.whitemagicsoftware.keenquotes.parser.Stem;
import com.whitemagicsoftware.keenquotes.parser.TokenType;
import java.util.Map;

final class Token
implements Comparable<Token>,
Stem {
    public static final Token NONE = new Token(TokenType.NONE, Lexeme.NONE);
    private TokenType mTokenType;
    private final int mBegan;
    private final int mEnded;

    Token(TokenType type, Lexeme lexeme) {
        this(type, lexeme.began(), lexeme.ended());
    }

    Token(TokenType tokenType, int began, int ended) {
        assert (tokenType != null);
        assert (began >= 0);
        assert (ended >= began);
        this.mTokenType = tokenType;
        this.mBegan = began;
        this.mEnded = ended;
    }

    boolean isBefore(Token token) {
        assert (token != null);
        assert (token != NONE);
        return this.mEnded <= token.mBegan;
    }

    boolean isAfter(Token token) {
        assert (token != null);
        assert (token != NONE);
        return this.mBegan > token.mEnded;
    }

    TokenType getType() {
        return this.mTokenType;
    }

    boolean isType(TokenType tokenType) {
        assert (tokenType != null);
        return this.mTokenType == tokenType;
    }

    int began() {
        return this.mBegan;
    }

    int ended() {
        return this.mEnded;
    }

    boolean isAmbiguous() {
        return this.mTokenType == TokenType.AMBIGUOUS || this.mTokenType == TokenType.QUOTE_AMBIGUOUS_LEADING || this.mTokenType == TokenType.QUOTE_AMBIGUOUS_LAGGING;
    }

    void setTokenType(TokenType tokenType) {
        assert (this.isAmbiguous());
        assert (tokenType != null);
        this.mTokenType = tokenType;
        assert (!this.isAmbiguous());
    }

    @Override
    public int compareTo(Token that) {
        return this.mBegan - that.mBegan;
    }

    @Override
    public String toXml() {
        return "<" + this.mTokenType + " type='" + this.getType().name() + "' began='" + this.began() + "' ended='" + this.ended() + "' />";
    }

    public String toString(Map<TokenType, String> entities) {
        return entities.get((Object)this.getType());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[mType=" + this.mTokenType + ", mBegan=" + this.mBegan + ", mEnded=" + this.mEnded + "]";
    }
}

