/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.Char;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.CharSymbolAtom;
import com.whitemagicsoftware.tex.atoms.SymbolAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.CharBox;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;
import com.whitemagicsoftware.tex.exceptions.InvalidSymbolTypeException;
import com.whitemagicsoftware.tex.exceptions.InvalidTeXFormulaException;
import com.whitemagicsoftware.tex.exceptions.SymbolNotFoundException;

public class AccentedAtom
extends Atom {
    private final SymbolAtom accent;
    protected Atom base;

    /*
     * WARNING - void declaration
     */
    public AccentedAtom(Atom base, Atom accent) throws InvalidSymbolTypeException {
        void var2_2;
        void var1_1;
        this.base = var1_1;
        if (!(accent instanceof SymbolAtom)) {
            throw new InvalidSymbolTypeException("Invalid accent");
        }
        this.accent = (SymbolAtom)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public AccentedAtom(Atom base, String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException {
        void var2_2;
        this.accent = SymbolAtom.get(accentName);
        if (this.accent.type == 10) {
            void var1_1;
            this.base = var1_1;
            return;
        }
        throw new InvalidSymbolTypeException("The symbol with the name '" + (String)var2_2 + "' is not defined as an accent (type='acc') in 'TeXSymbols.xml'");
    }

    /*
     * WARNING - void declaration
     */
    public AccentedAtom(Atom base, TeXFormula acc) throws InvalidTeXFormulaException, InvalidSymbolTypeException {
        if (acc == null) {
            throw new InvalidTeXFormulaException("The accent TeXFormula can't be null!");
        }
        Atom root = acc.getRoot();
        if (root instanceof SymbolAtom) {
            void var2_2;
            this.accent = (SymbolAtom)var2_2;
            if (this.accent.type == 10) {
                void var1_1;
                this.base = var1_1;
                return;
            }
            throw new InvalidSymbolTypeException("The accent TeXFormula represents a single symbol with the name '" + this.accent.getName() + "', but this symbol is not defined as an accent (type='acc') in 'TeXSymbols.xml'");
        }
        throw new InvalidTeXFormulaException("The accent TeXFormula does not represent a single symbol!");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Box createBox(TeXEnvironment env) {
        void var2_3;
        void var1_2;
        void var3_6;
        Box y;
        float f;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Box b = this.base == null ? new StrutBox() : this.base.createBox(env.crampStyle());
        float u = b.getWidth();
        float s = 0.0f;
        if (this.base instanceof CharSymbolAtom) {
            s = tf.getSkew(((CharSymbolAtom)this.base).getCharFont(tf), style);
        }
        Char ch = tf.getChar(this.accent.getName(), style);
        while (tf.hasNextLarger(ch)) {
            Char char_;
            Char larger = tf.getNextLarger(ch, style);
            if (!(char_.getWidth() <= u)) break;
            ch = larger;
        }
        float delta = Math.min(b.getHeight(), tf.getXHeight(style, ch.getFontId()));
        VerticalBox vBox = new VerticalBox();
        float italic = ch.getItalic();
        if (f > 1.0E-7f) {
            y = new HorizontalBox(new CharBox(ch));
            y.add(new StrutBox(italic));
        } else {
            y = new CharBox(ch);
        }
        float diff = (u - y.getWidth()) / 2.0f;
        y.setShift(s + (diff > 0.0f ? diff : 0.0f));
        if (diff < 0.0f) {
            b = new HorizontalBox(b, y.getWidth(), 2);
        }
        vBox.add(y);
        vBox.add(new StrutBox(0.0f, -delta, 0.0f, 0.0f));
        vBox.add(b);
        float total = vBox.getHeight() + vBox.getDepth();
        float d = b.getDepth();
        vBox.setDepth(d);
        vBox.setHeight((float)(var3_6 - var1_2));
        return var2_3;
    }
}

