/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CloseableThreadLocal;

public abstract class Analyzer
implements Closeable {
    private final ReuseStrategy reuseStrategy;
    CloseableThreadLocal<Object> storedValue = new CloseableThreadLocal();
    private static ReuseStrategy GLOBAL_REUSE_STRATEGY = new ReuseStrategy(){

        @Override
        public final TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            return (TokenStreamComponents)1.getStoredValue(analyzer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            void var3_3;
            1.setStoredValue(analyzer, var3_3);
        }
    };

    protected Analyzer() {
        this(GLOBAL_REUSE_STRATEGY);
    }

    /*
     * WARNING - void declaration
     */
    private Analyzer(ReuseStrategy reuseStrategy) {
        void var1_1;
        this.reuseStrategy = var1_1;
    }

    protected abstract TokenStreamComponents createComponents$2e873add();

    /*
     * WARNING - void declaration
     */
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        void var3_3;
        void var2_2;
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, fieldName);
        Reader r = this.initReader$7cc0ed37(reader);
        if (components == null) {
            void var1_1;
            components = this.createComponents$2e873add();
            this.reuseStrategy.setReusableComponents(this, (String)var1_1, components);
        }
        components.setReader((Reader)var2_2);
        return var3_3.getTokenStream();
    }

    protected Reader initReader$7cc0ed37(Reader reader) {
        return reader;
    }

    @Override
    public void close() {
        if (this.storedValue != null) {
            this.storedValue.close();
            this.storedValue = null;
        }
    }

    static {
        new ReuseStrategy(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
                Map componentsPerField = (Map)2.getStoredValue(analyzer);
                if (componentsPerField != null) {
                    void var2_2;
                    void var1_1;
                    return (TokenStreamComponents)var1_1.get(var2_2);
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
                void var3_3;
                void var2_2;
                HashMap<void, void> componentsPerField = (HashMap<void, void>)2.getStoredValue(analyzer);
                if (componentsPerField == null) {
                    void var1_1;
                    componentsPerField = new HashMap<void, void>();
                    2.setStoredValue((Analyzer)var1_1, componentsPerField);
                }
                componentsPerField.put(var2_2, var3_3);
            }
        };
    }

    public static abstract class ReuseStrategy {
        protected ReuseStrategy() {
        }

        public abstract TokenStreamComponents getReusableComponents(Analyzer var1, String var2);

        public abstract void setReusableComponents(Analyzer var1, String var2, TokenStreamComponents var3);

        protected static Object getStoredValue(Analyzer analyzer) {
            Analyzer analyzer2;
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            return analyzer2.storedValue.get();
        }

        /*
         * WARNING - void declaration
         */
        protected static void setStoredValue(Analyzer analyzer, Object storedValue) {
            void var1_1;
            Analyzer analyzer2;
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            analyzer2.storedValue.set(var1_1);
        }
    }

    public static final class TokenStreamComponents {
        private Consumer<Reader> source;
        private TokenStream sink;

        /*
         * WARNING - void declaration
         */
        public TokenStreamComponents(Consumer<Reader> source, TokenStream result) {
            void var2_2;
            void var1_1;
            this.source = var1_1;
            this.sink = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public TokenStreamComponents(Tokenizer tokenizer, TokenStream result) {
            this(((Tokenizer)var1_1)::setReader, (TokenStream)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void setReader(Reader reader) {
            void var1_1;
            this.source.accept((Reader)var1_1);
        }

        public final TokenStream getTokenStream() {
            return this.sink;
        }
    }
}

