/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.cn.smart.AnalyzerProfile;
import org.apache.lucene.analysis.cn.smart.Utility;
import org.apache.lucene.analysis.cn.smart.hhmm.AbstractDictionary;

final class WordDictionary
extends AbstractDictionary {
    private static WordDictionary singleInstance;
    private short[] wordIndexTable;
    private char[] charIndexTable;
    private char[][][] wordItem_charArrayTable;
    private int[][] wordItem_frequencyTable;

    private WordDictionary() {
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized WordDictionary getInstance() {
        if (singleInstance == null) {
            singleInstance = new WordDictionary();
            try {
                WordDictionary wordDictionary = singleInstance;
                InputStream inputStream = wordDictionary.getClass().getResourceAsStream("coredict.mem");
                wordDictionary.loadFromObjectInputStream(inputStream);
            }
            catch (IOException iOException) {
                Object wordDictRoot;
                Object object = wordDictRoot = AnalyzerProfile.ANALYSIS_DATA_DIR;
                wordDictRoot = singleInstance;
                Object object2 = (String)object + "/coredict.dct";
                object = Paths.get((String)object + "/coredict.mem", new String[0]);
                if (Files.exists((Path)object, new LinkOption[0])) {
                    ((WordDictionary)wordDictRoot).loadFromObj((Path)object);
                }
                try {
                    ((WordDictionary)wordDictRoot).wordIndexTable = new short[12071];
                    ((WordDictionary)wordDictRoot).charIndexTable = new char[12071];
                    for (int i = 0; i < 12071; ++i) {
                        ((WordDictionary)wordDictRoot).charIndexTable[i] = '\u0000';
                        ((WordDictionary)wordDictRoot).wordIndexTable[i] = -1;
                    }
                    ((WordDictionary)wordDictRoot).wordItem_charArrayTable = new char[8178][][];
                    ((WordDictionary)wordDictRoot).wordItem_frequencyTable = new int[8178][];
                    String string = object2;
                    object2 = wordDictRoot;
                    int n = 0;
                    int[] nArray = new int[3];
                    byte[] byArray = new byte[4];
                    DataInputStream dataInputStream = new DataInputStream(Files.newInputStream(Paths.get(string, new String[0]), new OpenOption[0]));
                    for (int i = 1410; i < 8178; ++i) {
                        dataInputStream.read(byArray);
                        int n2 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
                        if (n2 <= 0) {
                            ((WordDictionary)object2).wordItem_charArrayTable[i] = null;
                            ((WordDictionary)object2).wordItem_frequencyTable[i] = null;
                            continue;
                        }
                        ((WordDictionary)object2).wordItem_charArrayTable[i] = new char[n2][];
                        ((WordDictionary)object2).wordItem_frequencyTable[i] = new int[n2];
                        n += n2;
                        for (int j = 0; j < n2; ++j) {
                            dataInputStream.read(byArray);
                            nArray[0] = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
                            dataInputStream.read(byArray);
                            nArray[1] = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
                            dataInputStream.read(byArray);
                            nArray[2] = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
                            ((WordDictionary)object2).wordItem_frequencyTable[i][j] = nArray[0];
                            int n3 = nArray[1];
                            if (n3 > 0) {
                                Object object3 = new byte[n3];
                                dataInputStream.read((byte[])object3);
                                object3 = new String((byte[])object3, "GB2312");
                                ((WordDictionary)object2).wordItem_charArrayTable[i][j] = ((String)object3).toCharArray();
                                continue;
                            }
                            ((WordDictionary)object2).wordItem_charArrayTable[i][j] = null;
                        }
                        String string2 = WordDictionary.getCCByGB2312Id(i);
                        ((WordDictionary)object2).setTableIndex(string2.charAt(0), i);
                    }
                    dataInputStream.close();
                    ((WordDictionary)wordDictRoot).expandDelimiterData();
                    ((WordDictionary)wordDictRoot).mergeSameWords();
                    ((WordDictionary)wordDictRoot).sortEachItems();
                }
                catch (IOException iOException2) {
                    throw new RuntimeException(iOException2.getMessage());
                }
                ((WordDictionary)wordDictRoot).saveToObj((Path)object);
            }
            catch (ClassNotFoundException e) {
                void var0_2;
                throw new RuntimeException((Throwable)var0_2);
            }
        }
        return singleInstance;
    }

    /*
     * WARNING - void declaration
     */
    private boolean loadFromObj(Path serialObj) {
        try {
            this.loadFromObjectInputStream(Files.newInputStream(serialObj, new OpenOption[0]));
            return true;
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadFromObjectInputStream(InputStream serialObjectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream input = new ObjectInputStream(serialObjectInputStream);
        try {
            this.wordIndexTable = (short[])input.readObject();
            this.charIndexTable = (char[])input.readObject();
            this.wordItem_charArrayTable = (char[][][])input.readObject();
            this.wordItem_frequencyTable = (int[][])input.readObject();
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        input.close();
    }

    /*
     * WARNING - void declaration
     */
    private void saveToObj(Path serialObj) {
        try {
            ObjectOutputStream output = new ObjectOutputStream(Files.newOutputStream(serialObj, new OpenOption[0]));
            try {
                output.writeObject(this.wordIndexTable);
                output.writeObject(this.charIndexTable);
                output.writeObject(this.wordItem_charArrayTable);
                output.writeObject(this.wordItem_frequencyTable);
            }
            catch (Throwable throwable) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            output.close();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - void declaration
     */
    private void expandDelimiterData() {
        int i = 0;
        while (i < this.wordItem_charArrayTable[5165].length) {
            void var3_3;
            int k;
            char c = this.wordItem_charArrayTable[5165][i][0];
            short j = WordDictionary.getGB2312Id(c);
            if (this.wordItem_charArrayTable[j] != null) continue;
            for (k = i; k < this.wordItem_charArrayTable[5165].length && this.wordItem_charArrayTable[5165][k][0] == c; ++k) {
            }
            int cnt = k - i;
            if (cnt != 0) {
                this.wordItem_charArrayTable[j] = new char[cnt][];
                this.wordItem_frequencyTable[j] = new int[cnt];
            }
            k = 0;
            while (k < cnt) {
                this.wordItem_frequencyTable[j][k] = this.wordItem_frequencyTable[5165][i];
                this.wordItem_charArrayTable[j][k] = new char[this.wordItem_charArrayTable[5165][i].length - 1];
                System.arraycopy(this.wordItem_charArrayTable[5165][i], 1, this.wordItem_charArrayTable[j][k], 0, this.wordItem_charArrayTable[j][k].length);
                ++k;
                ++i;
            }
            this.setTableIndex((char)var3_3, j);
        }
        this.wordItem_charArrayTable[5165] = null;
        this.wordItem_frequencyTable[5165] = null;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeSameWords() {
        for (int i = 0; i < 8178; ++i) {
            void var2_3;
            void var3_5;
            if (this.wordItem_charArrayTable[i] == null) continue;
            int len = 1;
            for (int j = 1; j < this.wordItem_charArrayTable[i].length; ++j) {
                if (Utility.compareArray(this.wordItem_charArrayTable[i][j], 0, this.wordItem_charArrayTable[i][j - 1], 0) == 0) continue;
                ++len;
            }
            if (len >= this.wordItem_charArrayTable[i].length) continue;
            char[][] tempArray = new char[len][];
            int[] tempFreq = new int[len];
            int k = 0;
            tempArray[0] = this.wordItem_charArrayTable[i][0];
            tempFreq[0] = this.wordItem_frequencyTable[i][0];
            for (int j = 1; j < this.wordItem_charArrayTable[i].length; ++j) {
                if (Utility.compareArray(this.wordItem_charArrayTable[i][j], 0, tempArray[k], 0) != 0) {
                    tempArray[++k] = this.wordItem_charArrayTable[i][j];
                    tempFreq[k] = this.wordItem_frequencyTable[i][j];
                    continue;
                }
                int n = k;
                tempFreq[n] = tempFreq[n] + this.wordItem_frequencyTable[i][j];
            }
            this.wordItem_charArrayTable[i] = var3_5;
            this.wordItem_frequencyTable[i] = var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sortEachItems() {
        for (int i = 0; i < this.wordItem_charArrayTable.length; ++i) {
            if (this.wordItem_charArrayTable[i] == null || this.wordItem_charArrayTable[i].length <= 1) continue;
            for (int j = 0; j < this.wordItem_charArrayTable[i].length - 1; ++j) {
                for (int j2 = j + 1; j2 < this.wordItem_charArrayTable[i].length; ++j2) {
                    void var2_3;
                    void var1_2;
                    if (Utility.compareArray(this.wordItem_charArrayTable[i][j], 0, this.wordItem_charArrayTable[i][j2], 0) <= 0) continue;
                    char[] tmpArray = this.wordItem_charArrayTable[i][j];
                    int tmpFreq = this.wordItem_frequencyTable[i][j];
                    char[][] cArray = this.wordItem_charArrayTable[i];
                    cArray[j] = cArray[j2];
                    int[] nArray = this.wordItem_frequencyTable[i];
                    nArray[j] = nArray[j2];
                    this.wordItem_charArrayTable[i][j2] = var1_2;
                    this.wordItem_frequencyTable[i][j2] = var2_3;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean setTableIndex(char c, int j) {
        short index = this.getAvaliableTableIndex(c);
        if (index != -1) {
            void var2_2;
            void var1_1;
            this.charIndexTable[index] = var1_1;
            this.wordIndexTable[var3_3] = (short)var2_2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private short getAvaliableTableIndex(char c) {
        void var1_1;
        int i;
        int hash1 = (int)(WordDictionary.hash1(c) % 12071L);
        int hash2 = WordDictionary.hash2(c) % 12071;
        if (hash1 < 0) {
            hash1 += 12071;
        }
        if (hash2 < 0) {
            hash2 += 12071;
        }
        int index = hash1;
        for (i = 1; this.charIndexTable[index] != '\u0000' && this.charIndexTable[index] != c && i < 12071; ++i) {
            index = (hash1 + i * hash2) % 12071;
        }
        if (i < 12071 && (this.charIndexTable[index] == '\u0000' || this.charIndexTable[index] == var1_1)) {
            return (short)index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private short getWordItemTableIndex(char c) {
        void var1_1;
        int i;
        int hash1 = (int)(WordDictionary.hash1(c) % 12071L);
        int hash2 = WordDictionary.hash2(c) % 12071;
        if (hash1 < 0) {
            hash1 += 12071;
        }
        if (hash2 < 0) {
            hash2 += 12071;
        }
        int index = hash1;
        for (i = 1; this.charIndexTable[index] != '\u0000' && this.charIndexTable[index] != c && i < 12071; ++i) {
            index = (hash1 + i * hash2) % 12071;
        }
        if (i < 12071 && this.charIndexTable[index] == var1_1) {
            return (short)index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getPrefixMatch(char[] charArray, int knownStart) {
        void start;
        short index = this.getWordItemTableIndex(charArray[0]);
        if (index == -1) {
            return -1;
        }
        char[][] items = this.wordItem_charArrayTable[this.wordIndexTable[index]];
        int end = items.length - 1;
        void mid = (start + end) / 2;
        while (start <= end) {
            int cmpResult = Utility.compareArrayByPrefix(charArray, 1, items[mid], 0);
            if (cmpResult == 0) {
                while (mid >= 0 && Utility.compareArrayByPrefix(charArray, 1, items[mid], 0) == 0) {
                    --mid;
                }
                return (int)(++mid);
            }
            if (cmpResult < 0) {
                end = mid - true;
            } else {
                start = mid + true;
            }
            mid = (start + end) / 2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFrequency(char[] charArray) {
        int n;
        block9: {
            int hashIndex = this.getWordItemTableIndex(charArray[0]);
            if (hashIndex == -1) {
                return 0;
            }
            char[] cArray = charArray;
            int n2 = hashIndex;
            charArray = this;
            if (cArray == null || cArray.length == 0) {
                n = -1;
            } else {
                int itemIndex;
                charArray = charArray.wordItem_charArrayTable[charArray.wordIndexTable[n2]];
                n2 = 0;
                int n3 = ((char[])charArray).length - 1;
                int n4 = (n3 + 0) / 2;
                while (n2 <= n3) {
                    int n5 = Utility.compareArray((char[])charArray[n4], 0, cArray, 1);
                    if (n5 == 0) {
                        n = n4;
                        break block9;
                    }
                    if (n5 < 0) {
                        n2 = n4 + 1;
                    } else if (n5 > 0) {
                        n3 = n4 - 1;
                    }
                    n4 = (n2 + n3) / 2;
                }
                n = itemIndex = -1;
            }
        }
        if (n != -1) {
            void var1_2;
            void var2_3;
            return this.wordItem_frequencyTable[this.wordIndexTable[var2_3]][var1_2];
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isEqual(char[] charArray, int itemIndex) {
        void var2_2;
        void var3_3;
        void var1_1;
        short hashIndex = this.getWordItemTableIndex(charArray[0]);
        return Utility.compareArray((char[])var1_1, 1, this.wordItem_charArrayTable[this.wordIndexTable[var3_3]][var2_2], 0) == 0;
    }
}

