/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.Locale;

public abstract class CharArrayIterator
implements CharacterIterator {
    private char[] array;
    private int start;
    private int index;
    private int length;
    private int limit;
    private static boolean HAS_BUGGY_BREAKITERATORS;

    /*
     * WARNING - void declaration
     */
    public final void setText(char[] array, int start, int length) {
        void var3_3;
        void var1_1;
        this.array = var1_1;
        this.start = 0;
        this.index = 0;
        this.length = length;
        this.limit = var3_3 + false;
    }

    @Override
    public char current() {
        if (this.index == this.limit) {
            return '\uffff';
        }
        CharArrayIterator charArrayIterator = this;
        return charArrayIterator.jreBugWorkaround(charArrayIterator.array[this.index]);
    }

    protected abstract char jreBugWorkaround(char var1);

    @Override
    public char first() {
        this.index = this.start;
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.length;
    }

    @Override
    public int getIndex() {
        return this.index - this.start;
    }

    @Override
    public char last() {
        this.index = this.limit == this.start ? this.limit : this.limit - 1;
        return this.current();
    }

    @Override
    public char next() {
        if (++this.index >= this.limit) {
            this.index = this.limit;
            return '\uffff';
        }
        return this.current();
    }

    @Override
    public char previous() {
        if (--this.index < this.start) {
            this.index = this.start;
            return '\uffff';
        }
        return this.current();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char setIndex(int position) {
        void var1_1;
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException("Illegal Position: " + position);
        }
        this.index = this.start + var1_1;
        return this.current();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharArrayIterator clone() {
        try {
            return (CharArrayIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    public static CharArrayIterator newSentenceInstance() {
        if (HAS_BUGGY_BREAKITERATORS) {
            return new CharArrayIterator(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final char jreBugWorkaround(char ch) {
                    void var1_1;
                    if (ch >= '\ud800' && ch <= '\udfff') {
                        return ',';
                    }
                    return (char)var1_1;
                }
            };
        }
        return new CharArrayIterator(){

            @Override
            protected final char jreBugWorkaround(char ch) {
                return ch;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_1;
        boolean v;
        try {
            BreakIterator bi = BreakIterator.getSentenceInstance(Locale.US);
            bi.setText("\udb40\udc53");
            bi.next();
            v = false;
        }
        catch (Exception exception) {
            v = true;
        }
        HAS_BUGGY_BREAKITERATORS = var0_1;
    }
}

