/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.StringHelper;

public final class BytesRef
implements Cloneable,
Comparable<BytesRef> {
    private static byte[] EMPTY_BYTES = new byte[0];
    public byte[] bytes;
    public int offset;
    public int length;

    public BytesRef() {
        this(EMPTY_BYTES);
    }

    /*
     * WARNING - void declaration
     */
    private BytesRef(byte[] bytes, int offset, int length) {
        void var3_3;
        void var2_2;
        BytesRef bytesRef;
        this.bytes = bytesRef;
        this.offset = var2_2;
        this.length = var3_3;
        if (!$assertionsDisabled) {
            bytesRef = this;
            if (bytesRef.bytes == null) {
                throw new IllegalStateException("bytes is null");
            }
            if (bytesRef.length < 0) {
                throw new IllegalStateException("length is negative: " + bytesRef.length);
            }
            if (bytesRef.length > bytesRef.bytes.length) {
                throw new IllegalStateException("length is out of bounds: " + bytesRef.length + ",bytes.length=" + bytesRef.bytes.length);
            }
            if (bytesRef.offset < 0) {
                throw new IllegalStateException("offset is negative: " + bytesRef.offset);
            }
            if (bytesRef.offset > bytesRef.bytes.length) {
                throw new IllegalStateException("offset out of bounds: " + bytesRef.offset + ",bytes.length=" + bytesRef.bytes.length);
            }
            if (bytesRef.offset + bytesRef.length < 0) {
                throw new IllegalStateException("offset+length is negative: offset=" + bytesRef.offset + ",length=" + bytesRef.length);
            }
            if (bytesRef.offset + bytesRef.length > bytesRef.bytes.length) {
                throw new IllegalStateException("offset+length out of bounds: offset=" + bytesRef.offset + ",length=" + bytesRef.length + ",bytes.length=" + bytesRef.bytes.length);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public BytesRef(byte[] bytes) {
        this(bytes, 0, ((void)var1_1).length);
        void var1_1;
    }

    public final int hashCode() {
        return StringHelper.murmurhash3_x86_32(this, StringHelper.GOOD_FAST_HASH_SEED);
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BytesRef) {
            BytesRef bytesRef;
            BytesRef bytesRef2 = bytesRef;
            bytesRef = this;
            return Arrays.equals(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length, bytesRef2.bytes, bytesRef2.offset, bytesRef2.offset + bytesRef2.length);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(this.bytes[i] & 0xFF));
        }
        sb.append(']');
        return var1_1.toString();
    }
}

