/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.HorizontalRuleBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;

public class FractionAtom
extends Atom {
    private final boolean noDefault;
    private final int unit;
    private int numAlign = 2;
    private int denomAlign = 2;
    private final Atom numerator;
    private final Atom denominator;
    private float thickness;
    private float defFactor;
    private boolean defFactorSet;

    /*
     * WARNING - void declaration
     */
    public FractionAtom(Atom num, Atom den, boolean rule) {
        this((Atom)var1_1, (Atom)var2_2, var3_3 == false, 2, 0.0f);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FractionAtom(Atom num, Atom den, boolean noDef, int unit, float t) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        SpaceAtom.checkUnit(unit);
        this.numerator = var1_1;
        this.denominator = var2_2;
        this.noDefault = var3_3;
        this.thickness = t;
        this.unit = unit;
        this.type = 7;
    }

    /*
     * WARNING - void declaration
     */
    public FractionAtom(Atom num, Atom den, boolean rule, int numAlign, int denomAlign) {
        this((Atom)var1_1, (Atom)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.numAlign = FractionAtom.checkAlignment(numAlign);
        this.denomAlign = FractionAtom.checkAlignment(denomAlign);
    }

    /*
     * WARNING - void declaration
     */
    public FractionAtom(Atom num, Atom den, float defFactor, int numAlign, int denomAlign) {
        this((Atom)var1_1, (Atom)var2_2, true, numAlign, denomAlign);
        void var3_3;
        void var2_2;
        void var1_1;
        this.defFactor = var3_3;
        this.defFactorSet = true;
    }

    /*
     * WARNING - void declaration
     */
    public FractionAtom(Atom num, Atom den, int unit, float t, int numAlign, int denomAlign) {
        this((Atom)var1_1, (Atom)var2_2, (int)var3_3, t);
        void var3_3;
        void var2_2;
        void var1_1;
        this.numAlign = FractionAtom.checkAlignment(numAlign);
        this.denomAlign = FractionAtom.checkAlignment(denomAlign);
    }

    /*
     * WARNING - void declaration
     */
    public FractionAtom(Atom num, Atom den, int unit, float t) {
        this((Atom)var1_1, (Atom)var2_2, true, (int)var3_3, t);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    private static int checkAlignment(int align) {
        if (align == 0 || align == 1) {
            int n;
            return n;
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Box createBox(TeXEnvironment env) {
        void var1_1;
        float shiftDown;
        float shiftUp;
        Box denom;
        float f;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        float drt = tf.getDefaultRuleThickness(style);
        if (this.noDefault) {
            v0 = this;
            f = new SpaceAtom(this.unit, 0.0f, this.thickness, 0.0f).createBox(env).getHeight();
        } else {
            FractionAtom fractionAtom = this;
            v0 = fractionAtom;
            f = fractionAtom.defFactorSet ? this.defFactor * drt : drt;
        }
        v0.thickness = f;
        Box num = this.numerator == null ? new StrutBox() : this.numerator.createBox(env.numStyle());
        Box box = denom = this.denominator == null ? new StrutBox() : this.denominator.createBox(env.denomStyle());
        if (num.getWidth() < denom.getWidth()) {
            num = new HorizontalBox(num, denom.getWidth(), this.numAlign);
        } else {
            denom = new HorizontalBox(denom, num.getWidth(), this.denomAlign);
        }
        if (style < 2) {
            shiftUp = tf.getNum1(style);
            shiftDown = tf.getDenom1(style);
        } else {
            shiftDown = tf.getDenom2(style);
            shiftUp = this.thickness > 0.0f ? tf.getNum2(style) : tf.getNum3(style);
        }
        VerticalBox vBox = new VerticalBox();
        vBox.add(num);
        float axis = tf.getAxisHeight(style);
        if (this.thickness > 0.0f) {
            float clr = style < 2 ? 3.0f * this.thickness : this.thickness;
            float delta = this.thickness / 2.0f;
            kern1 = shiftUp - num.getDepth() - (axis + delta);
            float kern2 = axis - delta - (denom.getHeight() - shiftDown);
            float delta1 = clr - kern1;
            float delta2 = clr - kern2;
            if (delta1 > 0.0f) {
                shiftUp += delta1;
                kern1 += delta1;
            }
            if (delta2 > 0.0f) {
                shiftDown += delta2;
                kern2 += delta2;
            }
            vBox.add(new StrutBox(0.0f, kern1, 0.0f, 0.0f));
            vBox.add(new HorizontalRuleBox(this.thickness, num.getWidth(), 0.0f));
            vBox.add(new StrutBox(0.0f, kern2, 0.0f, 0.0f));
        } else {
            void v4;
            void var2_4;
            void kern2;
            float clr = kern2 < 2 ? 7.0f * kern1 : 3.0f * kern1;
            float kern = shiftUp - num.getDepth() - (denom.getHeight() - shiftDown);
            void delta = (var2_4 - kern) / 2.0f;
            if (v4 > 0.0f) {
                void var3_7;
                shiftUp += delta;
                shiftDown += delta;
                kern += var3_7 * 2.0f;
            }
            vBox.add(new StrutBox(0.0f, kern, 0.0f, 0.0f));
        }
        vBox.add(denom);
        vBox.setHeight(shiftUp + num.getHeight());
        vBox.setDepth(shiftDown + var1_1.getDepth());
        return vBox;
    }
}

