/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.IllegalAddException;
import org.jdom2.Parent;
import org.jdom2.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContentList
extends AbstractList<Content>
implements RandomAccess {
    private Content[] elementData = null;
    private int size;
    private transient int sizeModCount = Integer.MIN_VALUE;
    private transient int dataModiCount = Integer.MIN_VALUE;
    private final Parent parent;

    /*
     * WARNING - void declaration
     */
    ContentList(Parent parent) {
        void var1_1;
        this.parent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void setModCount(int sizemod, int datamod) {
        void var2_2;
        void var1_1;
        this.sizeModCount = var1_1;
        this.dataModiCount = var2_2;
    }

    private final void incModCount() {
        ++this.dataModiCount;
        ++this.sizeModCount;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIndex(int index, boolean excludes) {
        void var2_2;
        int max;
        int n = max = excludes ? this.size - 1 : this.size;
        if (index < 0 || index > var2_2) {
            void var1_1;
            throw new IndexOutOfBoundsException("Index: " + (int)var1_1 + " Size: " + this.size);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPreConditions(Content child, int index, boolean replace) {
        void var1_1;
        void var3_4;
        if (child == null) {
            throw new NullPointerException("Cannot add null object");
        }
        this.checkIndex(index, (boolean)var3_4);
        if (child.getParent() != null) {
            void var2_3;
            Parent p = child.getParent();
            if (p instanceof Document) {
                throw new IllegalAddException((Element)child, "The Content already has an existing parent document");
            }
            throw new IllegalAddException("The Content already has an existing parent \"" + ((Element)var2_3).getQualifiedName() + "\"");
        }
        if (child == this.parent) {
            throw new IllegalAddException("The Element cannot be added to itself");
        }
        if (this.parent instanceof Element && child instanceof Element && ((Element)var1_1).isAncestor((Element)this.parent)) {
            throw new IllegalAddException("The Element cannot be added as a descendent of itself");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, Content child) {
        this.checkPreConditions(child, index, false);
        this.parent.canContainContent(child, index, false);
        child.setParent(this.parent);
        ContentList contentList = this;
        contentList.ensureCapacity(contentList.size + 1);
        if (index == this.size) {
            this.elementData[this.size++] = child;
        } else {
            void var2_2;
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
            this.elementData[var1_1] = var2_2;
            ++this.size;
        }
        this.incModCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends Content> collection) {
        void var1_1;
        ContentList contentList = this;
        return contentList.addAll(contentList.size, (Collection<? extends Content>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends Content> collection) {
        if (collection == null) {
            throw new NullPointerException("Can not add a null collection to the ContentList");
        }
        this.checkIndex(index, false);
        if (collection.isEmpty()) {
            return false;
        }
        int addcnt = collection.size();
        if (addcnt == 1) {
            this.add(index, collection.iterator().next());
            return true;
        }
        ContentList contentList = this;
        contentList.ensureCapacity(contentList.size() + addcnt);
        ContentList contentList2 = this;
        int tmpmodcount = contentList2.sizeModCount;
        contentList2 = this;
        int tmpdmc = contentList2.dataModiCount;
        int count = 0;
        try {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Content c = (Content)iterator.next();
                this.add(index + count, c);
                ++count;
            }
        }
        catch (Throwable throwable) {
            void var3_4;
            while (--count >= 0) {
                this.remove(index + count);
            }
            this.setModCount((int)var3_4, tmpdmc);
            throw throwable;
        }
        return true;
    }

    @Override
    public final void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                Content content = this.elementData[i];
                Content content2 = content;
                content2 = content;
                content.setParent(null);
            }
            this.elementData = null;
            this.size = 0;
        }
        this.incModCount();
    }

    /*
     * WARNING - void declaration
     */
    final void ensureCapacity(int minCapacity) {
        void var2_2;
        void var1_1;
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(minCapacity, 4)];
            return;
        }
        if (minCapacity < this.elementData.length) {
            return;
        }
        int newcap = this.size * 3 / 2 + 1;
        this.elementData = 1.copyOf(this.elementData, (int)(newcap < minCapacity ? var1_1 : var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Content get(int index) {
        void var1_1;
        this.checkIndex(index, true);
        return this.elementData[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    final <E extends Content> List<E> getView(Filter<E> filter) {
        void var1_1;
        return new FilterList(this, var1_1);
    }

    final int indexOfFirstElement() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof Element)) continue;
                return i;
            }
        }
        return -1;
    }

    final int indexOfDocType() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof DocType)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Content remove(int index) {
        void var2_2;
        void var1_1;
        Content old;
        this.checkIndex(index, true);
        Content content = old = this.elementData[index];
        old.setParent(null);
        System.arraycopy(this.elementData, index + 1, this.elementData, index, this.size - var1_1 - 1);
        this.elementData[--this.size] = null;
        this.incModCount();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Content set(int index, Content child) {
        void var3_4;
        void var2_3;
        Content old;
        this.checkPreConditions(child, index, true);
        this.parent.canContainContent(child, index, true);
        Content content = old = this.elementData[index];
        old.setParent(null);
        child.setParent(this.parent);
        this.elementData[var1_1] = var2_3;
        ContentList contentList = this;
        ++contentList.dataModiCount;
        return var3_4;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Iterator<Content> iterator() {
        return new CLIterator(this, 0);
    }

    @Override
    public final ListIterator<Content> listIterator() {
        return new CLListIterator(this, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<Content> listIterator(int start) {
        void var1_1;
        return new CLListIterator(this, (int)var1_1);
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    private void sortInPlace(int[] indexes) {
        int i;
        int[] unsorted = 1.copyOf(indexes, indexes.length);
        Arrays.sort(unsorted);
        Content[] usc = new Content[unsorted.length];
        for (i = 0; i < usc.length; ++i) {
            usc[i] = this.elementData[indexes[i]];
        }
        for (i = 0; i < indexes.length; ++i) {
            this.elementData[unsorted[i]] = usc[i];
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sort(Comparator<? super Content> comp) {
        void var3_3;
        if (comp == null) {
            return;
        }
        int sz = this.size;
        int[] indexes = new int[sz];
        int i = 0;
        while (i < sz) {
            int ip;
            int n;
            block7: {
                int n2;
                Comparator<? super Content> comparator = comp;
                int n3 = n2 = i;
                int[] nArray = indexes;
                ContentList contentList = this;
                int n4 = 0;
                int n5 = n3 - 1;
                Content content = contentList.elementData[n2];
                while (n4 <= n5) {
                    n3 = n4 + n5 >>> 1;
                    n2 = comparator.compare(content, contentList.elementData[nArray[n3]]);
                    if (n2 == 0) {
                        while (n2 == 0 && n3 < n5 && comparator.compare(content, contentList.elementData[nArray[n3 + 1]]) == 0) {
                            ++n3;
                        }
                        n = n3 + 1;
                        break block7;
                    }
                    if (n2 < 0) {
                        n5 = n3 - 1;
                        continue;
                    }
                    n4 = n3 + 1;
                }
                n = ip = n4;
            }
            if (n < i) {
                System.arraycopy(indexes, ip, indexes, ip + 1, i - ip);
            }
            indexes[ip] = i++;
        }
        this.sortInPlace((int[])var3_3);
    }

    static /* synthetic */ int access$100(ContentList x0) {
        ContentList contentList = x0;
        return contentList.sizeModCount;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(ContentList x0, int x1, boolean x2) {
        void var1_1;
        x0.checkIndex((int)var1_1, false);
    }

    static /* synthetic */ int access$500(ContentList x0) {
        ContentList contentList = x0;
        return contentList.dataModiCount;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(ContentList x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        x0.setModCount((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(ContentList x0, int[] x1) {
        void var1_1;
        x0.sortInPlace((int[])var1_1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class FilterListIterator<F extends Content>
    implements ListIterator<F> {
        private final FilterList<F> filterlist;
        private boolean forward = false;
        private boolean canremove = false;
        private boolean canset = false;
        private int expectedmod = -1;
        private int cursor = -1;
        private /* synthetic */ ContentList this$0;

        /*
         * WARNING - void declaration
         */
        FilterListIterator(ContentList this$0, FilterList<F> flist, int start) {
            void var3_4;
            void var1_1;
            void var2_2;
            this.this$0 = this$0;
            this.filterlist = var2_2;
            this.expectedmod = ContentList.access$100(this$0);
            this.forward = false;
            if (start < 0) {
                throw new IndexOutOfBoundsException("Index: " + start + " Size: " + this.filterlist.size());
            }
            int n = FilterList.access$800(this.filterlist, start);
            if (n == ((ContentList)var1_1).size && start > this.filterlist.size()) {
                throw new IndexOutOfBoundsException("Index: " + start + " Size: " + this.filterlist.size());
            }
            this.cursor = var3_4;
        }

        private void checkConcurrent() {
            if (this.expectedmod != ContentList.access$100(this.this$0)) {
                throw new ConcurrentModificationException("The ContentList supporting the FilterList this iterator is processing has been modified by something other than this Iterator.");
            }
        }

        @Override
        public final boolean hasNext() {
            return FilterList.access$800(this.filterlist, this.forward ? this.cursor + 1 : this.cursor) < this.this$0.size;
        }

        @Override
        public final boolean hasPrevious() {
            return (this.forward ? this.cursor : this.cursor - 1) >= 0;
        }

        @Override
        public final int nextIndex() {
            if (this.forward) {
                return this.cursor + 1;
            }
            return this.cursor;
        }

        @Override
        public final int previousIndex() {
            if (this.forward) {
                return this.cursor;
            }
            return this.cursor - 1;
        }

        @Override
        public final void remove() {
            this.checkConcurrent();
            if (!this.canremove) {
                throw new IllegalStateException("Can not remove an element unless either next() or previous() has been called since the last remove()");
            }
            this.filterlist.remove(this.cursor);
            this.forward = false;
            this.expectedmod = ContentList.access$100(this.this$0);
            this.canremove = false;
            this.canset = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class FilterList<F extends Content>
    extends AbstractList<F> {
        private Filter<F> filter;
        private int[] backingpos;
        private int backingsize;
        private int xdata;
        private /* synthetic */ ContentList this$0;

        /*
         * WARNING - void declaration
         */
        FilterList(ContentList this$0, Filter<F> filter) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.backingpos = new int[this.this$0.size + 4];
            this.backingsize = 0;
            this.xdata = -1;
            this.filter = var2_2;
        }

        @Override
        public final boolean isEmpty() {
            return this.resync(0) == this.this$0.size;
        }

        private final int resync(int index) {
            if (this.xdata != ContentList.access$500(this.this$0)) {
                this.xdata = ContentList.access$500(this.this$0);
                this.backingsize = 0;
                if (this.this$0.size >= this.backingpos.length) {
                    this.backingpos = new int[this.this$0.size + 1];
                }
            }
            if (index >= 0 && index < this.backingsize) {
                return this.backingpos[index];
            }
            int bpi = 0;
            if (this.backingsize > 0) {
                bpi = this.backingpos[this.backingsize - 1] + 1;
            }
            while (bpi < this.this$0.size) {
                Content content = (Content)this.filter.filter(this.this$0.elementData[bpi]);
                if (content != null) {
                    this.backingpos[this.backingsize] = bpi;
                    if (this.backingsize++ == index) {
                        return bpi;
                    }
                }
                ++bpi;
            }
            return this.this$0.size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(int index, Content obj) {
            void var2_2;
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            int adj = this.resync(index);
            if (adj == this.this$0.size && index > this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            if (this.filter.matches(obj)) {
                void var1_1;
                void var3_3;
                this.this$0.add(adj, obj);
                if (this.backingpos.length <= this.this$0.size) {
                    this.backingpos = 1.copyOf(this.backingpos, this.backingpos.length + 1);
                }
                this.backingpos[index] = var3_3;
                this.backingsize = var1_1 + true;
                this.xdata = ContentList.access$500(this.this$0);
                return;
            }
            throw new IllegalAddException("Filter won't allow the " + obj.getClass().getName() + " '" + var2_2 + "' to be added to the list");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(int index, Collection<? extends F> collection) {
            if (collection == null) {
                throw new NullPointerException("Cannot add a null collection");
            }
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            int adj = this.resync(index);
            if (adj == this.this$0.size && index > this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            int addcnt = collection.size();
            if (addcnt == 0) {
                return false;
            }
            this.this$0.ensureCapacity(this.this$0.size() + addcnt);
            int tmpmodcount = ContentList.access$100(this.this$0);
            int tmpdmc = ContentList.access$500(this.this$0);
            int count = 0;
            try {
                Iterator iterator;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Content c = (Content)iterator.next();
                    if (c == null) {
                        throw new NullPointerException("Cannot add null content");
                    }
                    if (this.filter.matches(c)) {
                        this.this$0.add(adj + count, c);
                        if (this.backingpos.length <= this.this$0.size) {
                            this.backingpos = 1.copyOf(this.backingpos, this.backingpos.length + addcnt);
                        }
                        this.backingpos[index + count] = adj + count;
                        this.backingsize = index + count + 1;
                        this.xdata = ContentList.access$500(this.this$0);
                        ++count;
                        continue;
                    }
                    throw new IllegalAddException("Filter won't allow the " + c.getClass().getName() + " '" + c + "' to be added to the list");
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                while (--count >= 0) {
                    this.this$0.remove(adj + count);
                }
                ContentList.access$600(this.this$0, tmpmodcount, tmpdmc);
                this.backingsize = var1_1;
                this.xdata = tmpmodcount;
                throw throwable;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final F get(int index) {
            void var2_2;
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            int adj = this.resync(index);
            if (adj == this.this$0.size) {
                void var1_1;
                throw new IndexOutOfBoundsException("Index: " + (int)var1_1 + " Size: " + this.size());
            }
            return (F)((Content)this.filter.filter(this.this$0.get((int)var2_2)));
        }

        @Override
        public final Iterator<F> iterator() {
            return new FilterListIterator(this.this$0, this, 0);
        }

        @Override
        public final ListIterator<F> listIterator() {
            return new FilterListIterator(this.this$0, this, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListIterator<F> listIterator(int index) {
            void var1_1;
            return new FilterListIterator(this.this$0, this, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final F remove(int index) {
            void var2_3;
            void var1_1;
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            int adj = this.resync(index);
            if (adj == this.this$0.size) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            Content oldc = this.this$0.remove(adj);
            this.backingsize = var1_1;
            this.xdata = ContentList.access$500(this.this$0);
            return (F)((Content)this.filter.filter(var2_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final F set(int index, F obj) {
            void var2_3;
            void var1_1;
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            int adj = this.resync(index);
            if (adj == this.this$0.size) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            Content ins = (Content)this.filter.filter(obj);
            if (ins != null) {
                void var1_2;
                void var3_4;
                Content oldc = (Content)this.filter.filter(this.this$0.set((int)var3_4, ins));
                this.xdata = ContentList.access$500(this.this$0);
                return var1_2;
            }
            throw new IllegalAddException("Filter won't allow index " + (int)var1_1 + " to be set to " + var2_3.getClass().getName());
        }

        @Override
        public final int size() {
            this.resync(-1);
            return this.backingsize;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void sort(Comparator<? super F> comp) {
            void var3_3;
            if (comp == null) {
                return;
            }
            int sz = this.size();
            int[] indexes = new int[sz];
            for (int i = 0; i < sz; ++i) {
                int ip;
                int n;
                block7: {
                    int n2;
                    Comparator<F> comparator = comp;
                    int n3 = n2 = i;
                    int[] nArray = indexes;
                    FilterList filterList = this;
                    int n4 = 0;
                    int n5 = n3 - 1;
                    Content content = filterList.this$0.elementData[filterList.backingpos[n2]];
                    while (n4 <= n5) {
                        n2 = comparator.compare(content, filterList.this$0.elementData[nArray[n3]]);
                        if (n2 == 0) {
                            for (n3 = n4 + n5 >>> 1; n2 == 0 && n3 < n5 && comparator.compare(content, filterList.this$0.elementData[nArray[n3 + 1]]) == 0; ++n3) {
                            }
                            n = n3 + 1;
                            break block7;
                        }
                        if (n2 < 0) {
                            n5 = n3 - 1;
                            continue;
                        }
                        n4 = n3 + 1;
                    }
                    n = ip = n4;
                }
                if (n < i) {
                    System.arraycopy(indexes, ip, indexes, ip + 1, i - ip);
                }
                indexes[ip] = this.backingpos[i];
            }
            ContentList.access$700(this.this$0, (int[])var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$800(FilterList x0, int x1) {
            void var1_1;
            return x0.resync((int)var1_1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CLListIterator
    implements ListIterator<Content> {
        private boolean forward = false;
        private boolean canremove = false;
        private boolean canset = false;
        private int expectedmod = -1;
        private int cursor = -1;
        private /* synthetic */ ContentList this$0;

        /*
         * WARNING - void declaration
         */
        CLListIterator(ContentList contentList, int start) {
            void var2_2;
            this.this$0 = contentList;
            this.expectedmod = ContentList.access$100(contentList);
            this.forward = false;
            ContentList.access$400(contentList, start, false);
            this.cursor = var2_2;
        }

        private void checkConcurrent() {
            if (this.expectedmod != ContentList.access$100(this.this$0)) {
                throw new ConcurrentModificationException("The ContentList supporting this iterator has been modified bysomething other than this Iterator.");
            }
        }

        @Override
        public final boolean hasNext() {
            return (this.forward ? this.cursor + 1 : this.cursor) < this.this$0.size;
        }

        @Override
        public final boolean hasPrevious() {
            return (this.forward ? this.cursor : this.cursor - 1) >= 0;
        }

        @Override
        public final int nextIndex() {
            if (this.forward) {
                return this.cursor + 1;
            }
            return this.cursor;
        }

        @Override
        public final int previousIndex() {
            if (this.forward) {
                return this.cursor;
            }
            return this.cursor - 1;
        }

        @Override
        public final void remove() {
            this.checkConcurrent();
            if (!this.canremove) {
                throw new IllegalStateException("Can not remove an element unless either next() or previous() has been called since the last remove()");
            }
            this.this$0.remove(this.cursor);
            this.forward = false;
            this.expectedmod = ContentList.access$100(this.this$0);
            this.canremove = false;
            this.canset = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CLIterator
    implements Iterator<Content> {
        private int expect = -1;
        private int cursor = 0;
        private boolean canremove = false;
        private /* synthetic */ ContentList this$0;

        private CLIterator(ContentList contentList) {
            this.this$0 = contentList;
            this.expect = ContentList.access$100(contentList);
        }

        @Override
        public final boolean hasNext() {
            return this.cursor < this.this$0.size;
        }

        @Override
        public final void remove() {
            if (ContentList.access$100(this.this$0) != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (!this.canremove) {
                throw new IllegalStateException("Can only remove() content after a call to next()");
            }
            this.canremove = false;
            this.this$0.remove(--this.cursor);
            this.expect = ContentList.access$100(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ CLIterator(ContentList x0, byte by) {
            this((ContentList)var1_1);
            void var1_1;
        }
    }
}

