/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.hhmm.BigramDictionary;
import org.apache.lucene.analysis.cn.smart.hhmm.PathNode;
import org.apache.lucene.analysis.cn.smart.hhmm.SegGraph;
import org.apache.lucene.analysis.cn.smart.hhmm.SegTokenPair;

final class BiSegGraph {
    private Map<Integer, ArrayList<SegTokenPair>> tokenPairListTable = new HashMap<Integer, ArrayList<SegTokenPair>>();
    private List<WordlistLoader> segTokenList;
    private static BigramDictionary bigramDict = BigramDictionary.getInstance();

    /*
     * WARNING - void declaration
     */
    public BiSegGraph(SegGraph segGraph) {
        void var1_1;
        this.segTokenList = segGraph.makeIndex();
        this.generateBiSegGraph((SegGraph)var1_1);
    }

    private void generateBiSegGraph(SegGraph segGraph) {
        int maxStart = segGraph.getMaxStart();
        this.segTokenList = segGraph.makeIndex();
        block0: for (int key = -1; key < maxStart; ++key) {
            if (!segGraph.isStartExist(key)) continue;
            List<WordlistLoader> list = segGraph.getStartList(key);
            for (WordlistLoader t1 : list) {
                double oneWordFreq = t1.weight;
                List<WordlistLoader> nextTokens = null;
                for (int next = t1.endOffset; next <= maxStart; ++next) {
                    if (!segGraph.isStartExist(next)) continue;
                    nextTokens = segGraph.getStartList(next);
                    break;
                }
                if (nextTokens == null) continue block0;
                for (WordlistLoader t2 : nextTokens) {
                    int n;
                    BiSegGraph biSegGraph;
                    char[] idBuffer = new char[t1.charArray.length + t2.charArray.length + 1];
                    System.arraycopy(t1.charArray, 0, idBuffer, 0, t1.charArray.length);
                    idBuffer[t1.charArray.length] = 64;
                    System.arraycopy(t2.charArray, 0, idBuffer, t1.charArray.length + 1, t2.charArray.length);
                    int wordPairFreq = bigramDict.getFrequency(idBuffer);
                    double weight = -Math.log(0.1 * (oneWordFreq + 1.0) / 2159997.0 + 0.9 * (0.999999537036394 * (double)wordPairFreq / (oneWordFreq + 1.0) + 4.6296360596797126E-7));
                    SegTokenPair tokenPair = new SegTokenPair(idBuffer, t1.index, t2.index, weight);
                    void var6_9 = biSegGraph;
                    biSegGraph = this;
                    int n2 = n = var6_9.to;
                    Object object = biSegGraph;
                    if (!(((BiSegGraph)object).tokenPairListTable.get(n2) != null)) {
                        object = new ArrayList<void>();
                        ((ArrayList)object).add(var6_9);
                        biSegGraph.tokenPairListTable.put(n, (ArrayList<SegTokenPair>)object);
                        continue;
                    }
                    object = biSegGraph.tokenPairListTable.get(n);
                    object.add(var6_9);
                }
            }
        }
    }

    public final List<WordlistLoader> getShortPath() {
        int n;
        int current;
        BiSegGraph biSegGraph = this;
        int nodeCount = biSegGraph.tokenPairListTable.size();
        ArrayList<PathNode> path = new ArrayList<PathNode>();
        PathNode zeroPath = new PathNode();
        new PathNode().weight = 0.0;
        zeroPath.preNode = 0;
        path.add(zeroPath);
        for (current = 1; current <= nodeCount; ++current) {
            int n2 = current;
            biSegGraph = this;
            List edges = biSegGraph.tokenPairListTable.get(n2);
            double minWeight = Double.MAX_VALUE;
            SegTokenPair minEdge = null;
            for (SegTokenPair edge : edges) {
                PathNode pathNode;
                double weight = edge.weight;
                PathNode preNode = (PathNode)path.get(edge.from);
                if (!(pathNode.weight + weight < minWeight)) continue;
                minWeight = preNode.weight + weight;
                minEdge = edge;
            }
            PathNode newNode = new PathNode();
            new PathNode().weight = minWeight;
            newNode.preNode = minEdge.from;
            path.add(newNode);
        }
        current = n = path.size() - 1;
        ArrayList<Integer> rpath = new ArrayList<Integer>();
        ArrayList<WordlistLoader> resultPath = new ArrayList<WordlistLoader>();
        rpath.add(current);
        while (current != 0) {
            PathNode pathNode = (PathNode)path.get(current);
            int preNode = pathNode.preNode;
            rpath.add(preNode);
            current = preNode;
        }
        for (int j = rpath.size() - 1; j >= 0; --j) {
            Integer n3 = (Integer)rpath.get(j);
            int id = n3;
            WordlistLoader t = this.segTokenList.get(id);
            resultPath.add(t);
        }
        return resultPath;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        Object object = this.tokenPairListTable.values();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (ArrayList)object.next();
            object2 = ((ArrayList)object2).iterator();
            while (object2.hasNext()) {
                SegTokenPair pair = (SegTokenPair)object2.next();
                sb.append(pair).append("\n");
            }
        }
        return var1_1.toString();
    }
}

