/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.GraphvizFormatter;
import org.apache.lucene.analysis.ja.Token;
import org.apache.lucene.analysis.ja.dict.CharacterDefinition;
import org.apache.lucene.analysis.ja.dict.ConnectionCosts;
import org.apache.lucene.analysis.ja.dict.Dictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoDictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.analysis.ja.dict.UnknownDictionary;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.BaseFormAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.InflectionAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.util.RollingCharBuffer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;

public final class JapaneseTokenizer
extends Tokenizer {
    public static final Mode DEFAULT_MODE = Mode.SEARCH;
    private final EnumMap<Type, Dictionary> dictionaryMap = new EnumMap(Type.class);
    private final TokenInfoFST fst;
    private final TokenInfoDictionary dictionary;
    private final UnknownDictionary unkDictionary;
    private final ConnectionCosts costs;
    private final UserDictionary userDictionary;
    private final CharacterDefinition characterDefinition;
    private final FST.Arc<Long> arc = new FST.Arc();
    private final FST.BytesReader fstReader;
    private final IntsRef wordIdRef = new IntsRef();
    private final FST.BytesReader userFSTReader;
    private final TokenInfoFST userFST;
    private final RollingCharBuffer buffer = new RollingCharBuffer();
    private final WrappedPositionArray positions = new WrappedPositionArray();
    private final boolean discardPunctuation;
    private final boolean searchMode;
    private final boolean extendedMode;
    private final boolean outputCompounds;
    private boolean outputNBest = false;
    private int nBestCost = 0;
    private boolean end;
    private int lastBackTracePos;
    private int lastTokenPos;
    private int pos;
    private final List<Token> pending = new ArrayList<Token>();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = this.addAttribute(PositionLengthAttribute.class);
    private final BaseFormAttribute basicFormAtt = this.addAttribute(BaseFormAttribute.class);
    private final PartOfSpeechAttribute posAtt = this.addAttribute(PartOfSpeechAttribute.class);
    private final ReadingAttribute readingAtt = this.addAttribute(ReadingAttribute.class);
    private final InflectionAttribute inflectionAtt = this.addAttribute(InflectionAttribute.class);
    private GraphvizFormatter dotOut;
    private Lattice lattice = null;

    /*
     * WARNING - void declaration
     */
    public JapaneseTokenizer(UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, (UserDictionary)var1_1, true, true, mode);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private JapaneseTokenizer(AttributeFactory factory, UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        this((AttributeFactory)var1_1, TokenInfoDictionary.getInstance(), UnknownDictionary.getInstance(), ConnectionCosts.getInstance(), (UserDictionary)var2_2, (boolean)var3_3, discardCompoundToken, mode);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private JapaneseTokenizer(AttributeFactory factory, TokenInfoDictionary systemDictionary, UnknownDictionary unkDictionary, ConnectionCosts connectionCosts, UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        super((AttributeFactory)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.dictionary = var2_2;
        this.fst = this.dictionary.getFST();
        this.unkDictionary = unkDictionary;
        this.characterDefinition = unkDictionary.getCharacterDefinition();
        this.userDictionary = userDictionary;
        this.costs = connectionCosts;
        this.fstReader = this.fst.getBytesReader();
        if (userDictionary != null) {
            JapaneseTokenizer japaneseTokenizer = this;
            UserDictionary userDictionary2 = userDictionary;
            throw null;
        }
        this.userFST = null;
        this.userFSTReader = null;
        this.discardPunctuation = discardPunctuation;
        switch (mode) {
            case SEARCH: {
                this.searchMode = true;
                this.extendedMode = false;
                this.outputCompounds = !discardCompoundToken;
                break;
            }
            case EXTENDED: {
                this.searchMode = true;
                this.extendedMode = true;
                this.outputCompounds = !discardCompoundToken;
                break;
            }
            default: {
                this.searchMode = false;
                this.extendedMode = false;
                this.outputCompounds = false;
            }
        }
        this.buffer.reset(this.input);
        this.resetState();
        this.dictionaryMap.put(Type.KNOWN, this.dictionary);
        this.dictionaryMap.put(Type.UNKNOWN, (Dictionary)var3_3);
        this.dictionaryMap.put(Type.USER, userDictionary);
    }

    @Override
    public final void close() throws IOException {
        super.close();
        this.buffer.reset(this.input);
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.buffer.reset(this.input);
        this.resetState();
    }

    private void resetState() {
        this.positions.reset();
        this.pos = 0;
        this.end = false;
        this.lastBackTracePos = 0;
        this.lastTokenPos = -1;
        this.pending.clear();
        this.positions.get(0).add(0, 0, -1, -1, -1, Type.KNOWN);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void end() throws IOException {
        void var1_1;
        super.end();
        JapaneseTokenizer japaneseTokenizer = this;
        int finalOffset = japaneseTokenizer.correctOffset(japaneseTokenizer.pos);
        void v1 = var1_1;
        this.offsetAtt.setOffset((int)v1, (int)v1);
    }

    /*
     * WARNING - void declaration
     */
    private int computeSecondBestThreshold(int pos, int length) throws IOException {
        void var2_2;
        void var1_1;
        return this.computePenalty((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int computePenalty(int pos, int length) throws IOException {
        if (length > 2) {
            void var3_3;
            void pos2;
            boolean allKanji = true;
            int endPos = pos + length;
            while (pos2 < endPos) {
                if (!this.characterDefinition.isKanji((char)this.buffer.get((int)pos2))) {
                    allKanji = false;
                    break;
                }
                ++pos2;
            }
            if (var3_3 != false) {
                return (length - 2) * 3000;
            }
            if (length > 7) {
                void var2_2;
                return (int)((var2_2 - 7) * 1700);
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void add(Dictionary dict, Position fromPosData, int endPos, int wordID, Type type, boolean addPenalty) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        int wordCost = dict.getWordCost(wordID);
        int leftID = dict.getLeftId(wordID);
        int leastCost = Integer.MAX_VALUE;
        int leastIDX = -1;
        assert (fromPosData.count > 0);
        for (int idx = 0; idx < fromPosData.count; ++idx) {
            int cost = fromPosData.costs[idx] + this.costs.get(fromPosData.lastRightID[idx], leftID);
            if (cost >= leastCost) continue;
            leastCost = cost;
            leastIDX = idx;
        }
        leastCost += wordCost;
        if (addPenalty && type != Type.USER) {
            int n = fromPosData.pos;
            int penalty = this.computePenalty(n, endPos - n);
            leastCost += penalty;
        }
        assert (leftID == var1_1.getRightId(wordID));
        this.positions.get((int)var3_3).add(leastCost, leftID, var2_2.pos, leastIDX, wordID, type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean incrementToken() throws IOException {
        void var3_4;
        int n;
        JapaneseTokenizer japaneseTokenizer;
        block0: while (this.pending.size() == 0) {
            int n2;
            int n3;
            int n4;
            Position position;
            if (this.end) {
                return false;
            }
            japaneseTokenizer = this;
            n = -1;
            while (japaneseTokenizer.buffer.get(japaneseTokenizer.pos) != -1) {
                int n5;
                int n6;
                int n7;
                position = japaneseTokenizer.positions.get(japaneseTokenizer.pos);
                int n8 = n4 = japaneseTokenizer.positions.getNextPos() == japaneseTokenizer.pos + 1 ? 1 : 0;
                if (position.count == 0) {
                    ++japaneseTokenizer.pos;
                    continue;
                }
                if (japaneseTokenizer.pos > japaneseTokenizer.lastBackTracePos && position.count == 1 && n4 != 0) {
                    japaneseTokenizer.backtrace(position, 0);
                    position.costs[0] = 0;
                    if (japaneseTokenizer.pending.size() != 0) continue block0;
                }
                if (japaneseTokenizer.pos - japaneseTokenizer.lastBackTracePos >= 1024) {
                    Position position2;
                    n3 = -1;
                    n2 = Integer.MAX_VALUE;
                    Position position3 = null;
                    for (n4 = japaneseTokenizer.pos; n4 < japaneseTokenizer.positions.getNextPos(); ++n4) {
                        position2 = japaneseTokenizer.positions.get(n4);
                        for (n7 = 0; n7 < position2.count; ++n7) {
                            n6 = position2.costs[n7];
                            if (n6 >= n2) continue;
                            n2 = n6;
                            n3 = n7;
                            position3 = position2;
                        }
                    }
                    assert (n3 != -1);
                    for (n4 = japaneseTokenizer.pos; n4 < japaneseTokenizer.positions.getNextPos(); ++n4) {
                        position2 = japaneseTokenizer.positions.get(n4);
                        if (position2 != position3) {
                            position2.reset();
                            continue;
                        }
                        if (n3 != 0) {
                            position2.costs[0] = position2.costs[n3];
                            position2.lastRightID[0] = position2.lastRightID[n3];
                            position2.backPos[0] = position2.backPos[n3];
                            position2.backIndex[0] = position2.backIndex[n3];
                            position2.backID[0] = position2.backID[n3];
                            position2.backType[0] = position2.backType[n3];
                        }
                        position2.count = 1;
                    }
                    japaneseTokenizer.backtrace(position3, 0);
                    Arrays.fill(position3.costs, 0, position3.count, 0);
                    if (japaneseTokenizer.pos != position3.pos) {
                        assert (japaneseTokenizer.pos < position3.pos);
                        japaneseTokenizer.pos = position3.pos;
                    }
                    if (japaneseTokenizer.pending.size() == 0) continue;
                    continue block0;
                }
                n3 = 0;
                if (japaneseTokenizer.userFST != null) {
                    japaneseTokenizer.userFST.getFirstArc(japaneseTokenizer.arc);
                    n2 = 0;
                    int n9 = position.pos;
                    while ((n4 = japaneseTokenizer.buffer.get(n9)) != -1 && japaneseTokenizer.userFST.findTargetArc(n4, japaneseTokenizer.arc, japaneseTokenizer.arc, n9 == position.pos, japaneseTokenizer.userFSTReader) != null) {
                        n2 += japaneseTokenizer.arc.output().intValue();
                        if (japaneseTokenizer.arc.isFinal()) {
                            JapaneseTokenizer japaneseTokenizer2 = japaneseTokenizer;
                            japaneseTokenizer2.add(japaneseTokenizer2.userDictionary, position, n9 + 1, n2 + japaneseTokenizer.arc.nextFinalOutput().intValue(), Type.USER, false);
                            n3 = 1;
                        }
                        ++n9;
                    }
                }
                if (n3 == 0) {
                    japaneseTokenizer.fst.getFirstArc(japaneseTokenizer.arc);
                    n2 = 0;
                    int n10 = position.pos;
                    while ((n4 = japaneseTokenizer.buffer.get(n10)) != -1 && japaneseTokenizer.fst.findTargetArc(n4, japaneseTokenizer.arc, japaneseTokenizer.arc, n10 == position.pos, japaneseTokenizer.fstReader) != null) {
                        n2 += japaneseTokenizer.arc.output().intValue();
                        if (japaneseTokenizer.arc.isFinal()) {
                            japaneseTokenizer.dictionary.lookupWordIds(n2 + japaneseTokenizer.arc.nextFinalOutput().intValue(), japaneseTokenizer.wordIdRef);
                            for (n5 = 0; n5 < japaneseTokenizer.wordIdRef.length; ++n5) {
                                JapaneseTokenizer japaneseTokenizer3 = japaneseTokenizer;
                                japaneseTokenizer3.add(japaneseTokenizer3.dictionary, position, n10 + 1, japaneseTokenizer.wordIdRef.ints[japaneseTokenizer.wordIdRef.offset + n5], Type.KNOWN, false);
                                n3 = 1;
                            }
                        }
                        ++n10;
                    }
                }
                if (!japaneseTokenizer.searchMode && n > position.pos) {
                    ++japaneseTokenizer.pos;
                    continue;
                }
                n2 = (char)japaneseTokenizer.buffer.get(japaneseTokenizer.pos);
                if (n3 == 0 || japaneseTokenizer.characterDefinition.isInvoke((char)n2)) {
                    byte by = japaneseTokenizer.characterDefinition.getCharacterClass((char)n2);
                    n4 = JapaneseTokenizer.isPunctuation((char)n2) ? 1 : 0;
                    if (!japaneseTokenizer.characterDefinition.isGroup((char)n2)) {
                        n5 = 1;
                    } else {
                        n5 = 1;
                        n7 = japaneseTokenizer.pos + 1;
                        while (n5 < 1024 && (n6 = japaneseTokenizer.buffer.get(n7)) != -1 && by == japaneseTokenizer.characterDefinition.getCharacterClass((char)n6) && JapaneseTokenizer.isPunctuation((char)n6) == n4) {
                            ++n5;
                            ++n7;
                        }
                    }
                    japaneseTokenizer.unkDictionary.lookupWordIds(by, japaneseTokenizer.wordIdRef);
                    for (n7 = 0; n7 < japaneseTokenizer.wordIdRef.length; ++n7) {
                        JapaneseTokenizer japaneseTokenizer4 = japaneseTokenizer;
                        Position position4 = position;
                        japaneseTokenizer4.add(japaneseTokenizer4.unkDictionary, position4, position4.pos + n5, japaneseTokenizer.wordIdRef.ints[japaneseTokenizer.wordIdRef.offset + n7], Type.UNKNOWN, false);
                    }
                    n = position.pos + n5;
                }
                ++japaneseTokenizer.pos;
            }
            japaneseTokenizer.end = true;
            if (japaneseTokenizer.pos <= 0) continue;
            position = japaneseTokenizer.positions.get(japaneseTokenizer.pos);
            n4 = Integer.MAX_VALUE;
            n3 = -1;
            for (n2 = 0; n2 < position.count; ++n2) {
                int n11 = position.costs[n2] + japaneseTokenizer.costs.get(position.lastRightID[n2], 0);
                if (n11 >= n4) continue;
                n4 = n11;
                n3 = n2;
            }
            japaneseTokenizer.backtrace(position, n3);
        }
        Token token = this.pending.remove(this.pending.size() - 1);
        int position = token.getPosition();
        int length = token.getLength();
        this.clearAttributes();
        assert (length > 0);
        this.termAtt.copyBuffer(token.getSurfaceForm(), token.getOffset(), length);
        this.offsetAtt.setOffset(this.correctOffset(position), this.correctOffset(n + var3_4));
        if (token.getPosition() == this.lastTokenPos) {
            this.posIncAtt.setPositionIncrement(0);
            this.posLengthAtt.setPositionLength(token.getPositionLength());
        } else {
            assert (token.getPosition() > this.lastTokenPos);
            this.posIncAtt.setPositionIncrement(1);
            this.posLengthAtt.setPositionLength(1);
        }
        this.lastTokenPos = ((Token)((Object)japaneseTokenizer)).getPosition();
        return true;
    }

    private void pruneAndRescore(int startPos, int endPos, int bestStartIDX) throws IOException {
        Position posData;
        int pos;
        for (pos = endPos; pos > startPos; --pos) {
            posData = this.positions.get(pos);
            for (int arcIDX = 0; arcIDX < posData.count; ++arcIDX) {
                int backPos22 = posData.backPos[arcIDX];
                if (backPos22 < startPos) continue;
                Type type = posData.backType[arcIDX];
                int n = posData.backID[arcIDX];
                int n2 = arcIDX;
                int n3 = pos;
                Position backPos22 = this.positions.get(backPos22);
                if (backPos22.forwardCount == backPos22.forwardID.length) {
                    Position position = backPos22;
                    backPos22.forwardPos = ArrayUtil.grow(position.forwardPos, 1 + position.forwardCount);
                    position.forwardID = ArrayUtil.grow(position.forwardID, 1 + position.forwardCount);
                    position.forwardIndex = ArrayUtil.grow(position.forwardIndex, 1 + position.forwardCount);
                    Type[] typeArray = new Type[position.forwardPos.length];
                    System.arraycopy(position.forwardType, 0, typeArray, 0, position.forwardType.length);
                    position.forwardType = typeArray;
                }
                backPos22.forwardPos[backPos22.forwardCount] = n3;
                backPos22.forwardIndex[backPos22.forwardCount] = n2;
                backPos22.forwardID[backPos22.forwardCount] = n;
                backPos22.forwardType[backPos22.forwardCount] = type;
                ++backPos22.forwardCount;
            }
            if (pos == startPos) continue;
            posData.count = 0;
        }
        for (pos = startPos; pos < endPos; ++pos) {
            posData = this.positions.get(pos);
            if (posData.count != 0) {
                if (pos == startPos) {
                    int rightID = startPos == 0 ? 0 : this.getDict(posData.backType[bestStartIDX]).getRightId(posData.backID[bestStartIDX]);
                    int pathCost = posData.costs[bestStartIDX];
                    for (int forwardArcIDX = 0; forwardArcIDX < posData.forwardCount; ++forwardArcIDX) {
                        Type forwardType = posData.forwardType[forwardArcIDX];
                        Dictionary dict2 = this.getDict(forwardType);
                        int wordID = posData.forwardID[forwardArcIDX];
                        int toPos = posData.forwardPos[forwardArcIDX];
                        int newCost = pathCost + dict2.getWordCost(wordID) + this.costs.get(rightID, dict2.getLeftId(wordID)) + this.computePenalty(pos, toPos - pos);
                        this.positions.get(toPos).add(newCost, dict2.getRightId(wordID), pos, bestStartIDX, wordID, forwardType);
                    }
                } else {
                    for (int forwardArcIDX = 0; forwardArcIDX < posData.forwardCount; ++forwardArcIDX) {
                        Type forwardType = posData.forwardType[forwardArcIDX];
                        int toPos = posData.forwardPos[forwardArcIDX];
                        JapaneseTokenizer japaneseTokenizer = this;
                        japaneseTokenizer.add(japaneseTokenizer.getDict(forwardType), posData, toPos, posData.forwardID[forwardArcIDX], forwardType, true);
                    }
                }
            }
            posData.forwardCount = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void backtrace(Position endPosData, int fromIDX) throws IOException {
        void var3_4;
        int endPos = endPosData.pos;
        if (endPos == this.lastBackTracePos) {
            return;
        }
        char[] fragment = this.buffer.get(this.lastBackTracePos, endPos - this.lastBackTracePos);
        if (this.dotOut != null) {
            JapaneseTokenizer japaneseTokenizer = this;
            this.dotOut.onBacktrace(japaneseTokenizer, japaneseTokenizer.positions, this.lastBackTracePos, endPosData, fromIDX, fragment, this.end);
        }
        int pos = endPos;
        Token altToken = null;
        int lastLeftWordID = -1;
        int backCount = 0;
        while (pos > this.lastBackTracePos) {
            int n;
            int penalty;
            void bestIDX;
            Position posData = this.positions.get(pos);
            assert (bestIDX < posData.count);
            int backPos = posData.backPos[bestIDX];
            assert (backPos >= this.lastBackTracePos) : "backPos=" + backPos + " vs lastBackTracePos=" + this.lastBackTracePos;
            int length = pos - backPos;
            Type backType = posData.backType[bestIDX];
            int backID = posData.backID[bestIDX];
            int nextBestIDX = posData.backIndex[bestIDX];
            if (this.searchMode && altToken == null && backType != Type.USER && (penalty = this.computeSecondBestThreshold(backPos, pos - backPos)) > 0) {
                int maxCost = posData.costs[bestIDX] + penalty;
                if (lastLeftWordID != -1) {
                    maxCost += this.costs.get(this.getDict(backType).getRightId(backID), lastLeftWordID);
                }
                this.pruneAndRescore(backPos, pos, posData.backIndex[bestIDX]);
                int leastCost = Integer.MAX_VALUE;
                int leastIDX = -1;
                for (int idx = 0; idx < posData.count; ++idx) {
                    int cost = posData.costs[idx];
                    if (lastLeftWordID != -1) {
                        cost += this.costs.get(this.getDict(posData.backType[idx]).getRightId(posData.backID[idx]), lastLeftWordID);
                    }
                    if (cost >= leastCost) continue;
                    leastCost = cost;
                    leastIDX = idx;
                }
                if (leastIDX != -1 && leastCost <= maxCost && posData.backPos[leastIDX] != backPos) {
                    assert (posData.backPos[leastIDX] != backPos);
                    altToken = new Token(backID, fragment, backPos - this.lastBackTracePos, length, backType, backPos, this.getDict(backType));
                    leastCost = leastIDX;
                    nextBestIDX = posData.backIndex[leastCost];
                    backPos = posData.backPos[leastCost];
                    length = pos - backPos;
                    backType = posData.backType[leastCost];
                    backID = posData.backID[leastCost];
                    backCount = 0;
                }
            }
            int offset = backPos - this.lastBackTracePos;
            assert (offset >= 0);
            if (altToken != null && altToken.getPosition() >= backPos) {
                if (this.outputCompounds) {
                    assert (altToken.getPosition() == backPos) : altToken.getPosition() + " vs " + backPos;
                    if (backCount > 0) {
                        altToken.setPositionLength(++backCount);
                        this.pending.add(altToken);
                    } else assert (this.discardPunctuation);
                }
                altToken = null;
            }
            Dictionary dict = this.getDict(backType);
            if (backType == Type.USER) {
                UserDictionary userDictionary = this.userDictionary;
                int n2 = backID;
                throw null;
            }
            if (this.extendedMode && backType == Type.UNKNOWN) {
                int unigramTokenCount = 0;
                for (int i = length - 1; i >= 0; --i) {
                    int charLen = 1;
                    if (i > 0 && Character.isLowSurrogate(fragment[offset + i])) {
                        --i;
                        charLen = 2;
                    }
                    if (this.discardPunctuation && JapaneseTokenizer.isPunctuation(fragment[offset + i])) continue;
                    this.pending.add(new Token(CharacterDefinition.NGRAM, fragment, offset + i, charLen, Type.UNKNOWN, backPos + i, this.unkDictionary));
                    ++unigramTokenCount;
                }
                backCount += n;
            } else if (!this.discardPunctuation || length == 0 || !JapaneseTokenizer.isPunctuation(fragment[offset])) {
                this.pending.add(new Token(backID, fragment, offset, length, backType, backPos, dict));
                ++backCount;
            }
            lastLeftWordID = dict.getLeftId(backID);
            pos = backPos;
            n = nextBestIDX;
        }
        this.lastBackTracePos = endPos;
        this.buffer.freeBefore(endPos);
        this.positions.freeBefore((int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    final Dictionary getDict(Type type) {
        void var1_1;
        return this.dictionaryMap.get(var1_1);
    }

    private static boolean isPunctuation(char ch) {
        switch (Character.getType(ch)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    static final class Lattice {
    }

    static final class WrappedPositionArray {
        private Position[] positions = new Position[8];
        private int nextWrite;
        private int nextPos;
        private int count;

        public WrappedPositionArray() {
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = new Position();
            }
        }

        public final void reset() {
            --this.nextWrite;
            while (this.count > 0) {
                if (this.nextWrite == -1) {
                    this.nextWrite = this.positions.length - 1;
                }
                this.positions[this.nextWrite--].reset();
                --this.count;
            }
            this.nextWrite = 0;
            this.nextPos = 0;
            this.count = 0;
        }

        /*
         * WARNING - void declaration
         */
        public final Position get(int pos) {
            void var2_3;
            void var1_1;
            int n;
            Position[] newPositions;
            while (pos >= this.nextPos) {
                if (this.count == this.positions.length) {
                    newPositions = new Position[ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    System.arraycopy(this.positions, this.nextWrite, newPositions, 0, this.positions.length - this.nextWrite);
                    System.arraycopy(this.positions, 0, newPositions, this.positions.length - this.nextWrite, this.nextWrite);
                    for (int i = this.positions.length; i < newPositions.length; ++i) {
                        newPositions[i] = new Position();
                    }
                    this.nextWrite = this.positions.length;
                    this.positions = newPositions;
                }
                if (this.nextWrite == this.positions.length) {
                    this.nextWrite = 0;
                }
                assert (this.positions[this.nextWrite].count == 0);
                ++this.nextWrite;
                ++this.nextPos;
                this.positions[this.nextWrite].pos = this.positions[this.nextWrite].pos;
                ++this.count;
            }
            if (!$assertionsDisabled) {
                n = pos;
                newPositions = this;
                if (!(n < newPositions.nextPos && n >= newPositions.nextPos - newPositions.count)) {
                    throw new AssertionError();
                }
            }
            n = pos;
            newPositions = this;
            if ((n = this.nextWrite - (newPositions.nextPos - n)) < 0) {
                n += newPositions.positions.length;
            }
            int index = n;
            assert (this.positions[index].pos == var1_1);
            return this.positions[var2_3];
        }

        public final int getNextPos() {
            return this.nextPos;
        }

        /*
         * WARNING - void declaration
         */
        public final void freeBefore(int pos) {
            void var1_1;
            int toFree = this.count - (this.nextPos - pos);
            assert (toFree >= 0);
            assert (toFree <= this.count);
            int index = this.nextWrite - this.count;
            if (index < 0) {
                index += this.positions.length;
            }
            for (int i = 0; i < toFree; ++i) {
                if (index == this.positions.length) {
                    index = 0;
                }
                this.positions[index].reset();
                ++index;
            }
            this.count -= var1_1;
        }
    }

    static final class Position {
        int pos;
        int count;
        int[] costs = new int[8];
        int[] lastRightID = new int[8];
        int[] backPos = new int[8];
        int[] backIndex = new int[8];
        int[] backID = new int[8];
        Type[] backType = new Type[8];
        int forwardCount;
        int[] forwardPos = new int[8];
        int[] forwardID = new int[8];
        int[] forwardIndex = new int[8];
        Type[] forwardType = new Type[8];

        Position() {
        }

        /*
         * WARNING - void declaration
         */
        private void grow() {
            void var1_1;
            this.costs = ArrayUtil.grow(this.costs, 1 + this.count);
            this.lastRightID = ArrayUtil.grow(this.lastRightID, 1 + this.count);
            this.backPos = ArrayUtil.grow(this.backPos, 1 + this.count);
            this.backIndex = ArrayUtil.grow(this.backIndex, 1 + this.count);
            this.backID = ArrayUtil.grow(this.backID, 1 + this.count);
            Type[] newBackType = new Type[this.backID.length];
            System.arraycopy(this.backType, 0, newBackType, 0, this.backType.length);
            this.backType = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void add(int cost, int lastRightID, int backPos, int backIndex, int backID, Type backType) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.count == this.costs.length) {
                this.grow();
            }
            this.costs[this.count] = var1_1;
            this.lastRightID[this.count] = var2_2;
            this.backPos[this.count] = var3_3;
            this.backIndex[this.count] = backIndex;
            this.backID[this.count] = backID;
            this.backType[this.count] = backType;
            ++this.count;
        }

        public final void reset() {
            this.count = 0;
            assert (this.forwardCount == 0) : "pos=" + this.pos + " forwardCount=" + this.forwardCount;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type KNOWN = new Type();
        public static final /* enum */ Type UNKNOWN = new Type();
        public static final /* enum */ Type USER = new Type();

        static {
            Type[] typeArray = new Type[]{KNOWN, UNKNOWN, USER};
        }
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NORMAL = new Mode();
        public static final /* enum */ Mode SEARCH = new Mode();
        public static final /* enum */ Mode EXTENDED = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        static {
            $VALUES = new Mode[]{NORMAL, SEARCH, EXTENDED};
        }
    }
}

