/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public final class StandardTokenizer
extends Tokenizer {
    private StandardTokenizerImpl scanner;
    private static String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<NUM>", "<SOUTHEAST_ASIAN>", "<IDEOGRAPHIC>", "<HIRAGANA>", "<KATAKANA>", "<HANGUL>", "<EMOJI>"};
    private int skippedPositions;
    private int maxTokenLength = 255;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    /*
     * WARNING - void declaration
     */
    public final void setMaxTokenLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("maxTokenLength must be greater than zero");
        }
        if (length > 0x100000) {
            throw new IllegalArgumentException("maxTokenLength may not exceed 1048576");
        }
        if (length != this.maxTokenLength) {
            void var1_1;
            this.maxTokenLength = length;
            this.scanner.setBufferSize((int)var1_1);
        }
    }

    public StandardTokenizer() {
        StandardTokenizer standardTokenizer = this;
        this.scanner = new StandardTokenizerImpl(standardTokenizer.input);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.skippedPositions = 0;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                void var1_1;
                void var2_2;
                this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
                this.scanner.getText(this.termAtt);
                int start = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset((int)(var2_2 + this.termAtt.length())));
                this.typeAtt.setType(TOKEN_TYPES[var1_1]);
                return true;
            }
            ++this.skippedPositions;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void end() throws IOException {
        void var1_1;
        super.end();
        StandardTokenizer standardTokenizer = this;
        int finalOffset = standardTokenizer.correctOffset(standardTokenizer.scanner.yychar() + this.scanner.yylength());
        void v1 = var1_1;
        this.offsetAtt.setOffset((int)v1, (int)v1);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    @Override
    public final void close() throws IOException {
        super.close();
        this.scanner.yyreset(this.input);
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
        this.skippedPositions = 0;
    }
}

