/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.DataInput;

public final class CodecUtil {
    private CodecUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static int checkHeader(DataInput in, String codec, int minVersion, int maxVersion) throws IOException {
        void var3_4;
        void var2_3;
        void var1_1;
        DataInput dataInput;
        int actualHeader = CodecUtil.readBEInt(in);
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=1071082519", in);
        }
        String string = dataInput.readString();
        if (!string.equals(var1_1)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + string + " vs expected codec=" + (String)var1_1, dataInput);
        }
        int n = CodecUtil.readBEInt(dataInput);
        if (n < var2_3) {
            throw new IndexFormatTooOldException(dataInput, n, (int)var2_3, (int)var3_4);
        }
        if (n > var3_4) {
            throw new IndexFormatTooNewException(dataInput, n, (int)var2_3, (int)var3_4);
        }
        return n;
    }

    private static int readBEInt(DataInput in) throws IOException {
        DataInput dataInput;
        return (in.readByte() & 0xFF) << 24 | (in.readByte() & 0xFF) << 16 | (in.readByte() & 0xFF) << 8 | dataInput.readByte() & 0xFF;
    }

    static {
        CodecUtil.class.desiredAssertionStatus();
    }
}

