/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class AttributeSource {
    private final Map<Class<? extends Attribute>, AttributeImpl> attributes;
    private final Map<Class<? extends AttributeImpl>, AttributeImpl> attributeImpls;
    private final State[] currentState;
    private final AttributeFactory factory;
    private static final ClassValue<Class<? extends Attribute>[]> implInterfaces = new ClassValue<Class<? extends Attribute>[]>(){};

    public AttributeSource() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
    }

    /*
     * WARNING - void declaration
     */
    public AttributeSource(AttributeSource input) {
        void var1_1;
        Objects.requireNonNull(input, "input AttributeSource must not be null");
        this.attributes = input.attributes;
        this.attributeImpls = input.attributeImpls;
        this.currentState = input.currentState;
        this.factory = var1_1.factory;
    }

    /*
     * WARNING - void declaration
     */
    public AttributeSource(AttributeFactory factory) {
        void var1_1;
        this.attributes = new LinkedHashMap<Class<? extends Attribute>, AttributeImpl>();
        this.attributeImpls = new LinkedHashMap<Class<? extends AttributeImpl>, AttributeImpl>();
        this.currentState = new State[1];
        this.factory = (AttributeFactory)Objects.requireNonNull(var1_1, "AttributeFactory must not be null");
    }

    private void addAttributeImpl(AttributeImpl att) {
        Class<? extends Attribute>[] clazz = att.getClass();
        if (this.attributeImpls.containsKey(clazz)) {
            return;
        }
        Class<? extends Attribute>[] classArray = clazz;
        for (Class<? extends Attribute> curInterface : implInterfaces.get((Class<?>)classArray)) {
            if (this.attributes.containsKey(curInterface)) continue;
            this.currentState[0] = null;
            this.attributes.put(curInterface, att);
            this.attributeImpls.put((Class<? extends AttributeImpl>)clazz, att);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends Attribute> T addAttribute(Class<T> attClass) {
        void var2_2;
        void var1_1;
        AttributeImpl attImpl = this.attributes.get(attClass);
        if (attImpl == null) {
            if (!attClass.isInterface() || !Attribute.class.isAssignableFrom(attClass)) {
                throw new IllegalArgumentException("addAttribute() only accepts an interface that extends Attribute, but " + attClass.getName() + " does not fulfil this contract.");
            }
            AttributeSource attributeSource = this;
            attImpl = attributeSource.factory.createAttributeInstance(attClass);
            attributeSource.addAttributeImpl(attImpl);
        }
        return (T)((Attribute)var1_1.cast(var2_2));
    }

    private boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private State getCurrentState() {
        void var1_1;
        State s = this.currentState[0];
        if (s != null || !this.hasAttributes()) {
            return s;
        }
        s = this.currentState[0] = new State();
        State c = this.currentState[0];
        Iterator<AttributeImpl> it = this.attributeImpls.values().iterator();
        c.attribute = it.next();
        while (it.hasNext()) {
            c = c.next = new State();
            c.next.attribute = it.next();
        }
        return var1_1;
    }

    public final void clearAttributes() {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.clear();
            state = state.next;
        }
    }

    public final void endAttributes() {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.end();
            state = state.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int code = 0;
        State state = this.getCurrentState();
        while (state != null) {
            code = code * 31 + state.attribute.hashCode();
            state = state.next;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AttributeSource) {
            void var1_1;
            AttributeSource other = (AttributeSource)obj;
            if (this.hasAttributes()) {
                if (!other.hasAttributes()) {
                    return false;
                }
                if (this.attributeImpls.size() != other.attributeImpls.size()) {
                    return false;
                }
                State thisState = this.getCurrentState();
                State otherState = other.getCurrentState();
                while (thisState != null && otherState != null) {
                    if (otherState.attribute.getClass() != thisState.attribute.getClass() || !otherState.attribute.equals(thisState.attribute)) {
                        return false;
                    }
                    thisState = thisState.next;
                    otherState = otherState.next;
                }
                return true;
            }
            return !var1_1.hasAttributes();
        }
        return false;
    }

    private void reflectWith(AttributeReflector reflector) {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.reflectWith(reflector);
            state = state.next;
        }
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        String string2 = Integer.toHexString(System.identityHashCode(this));
        boolean bl = false;
        AttributeSource attributeSource = this;
        StringBuilder stringBuilder = new StringBuilder();
        attributeSource.reflectWith(new AttributeReflector(attributeSource, stringBuilder, false){
            private /* synthetic */ StringBuilder val$buffer;
            private /* synthetic */ boolean val$prependAttClass;
            {
                this.val$buffer = stringBuilder;
                this.val$prependAttClass = bl;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                void var3_3;
                void var2_2;
                if (this.val$buffer.length() > 0) {
                    this.val$buffer.append(',');
                }
                if (this.val$prependAttClass) {
                    void var1_1;
                    this.val$buffer.append(var1_1.getName()).append('#');
                }
                this.val$buffer.append((String)var2_2).append('=').append(value == null ? "null" : var3_3);
            }
        });
        return string + "@" + string2 + " " + stringBuilder.toString();
    }

    public static final class State
    implements Cloneable {
        AttributeImpl attribute;
        State next;

        /*
         * WARNING - void declaration
         */
        private State clone() {
            void var1_1;
            State clone = new State();
            new State().attribute = this.attribute.clone();
            if (this.next != null) {
                clone.next = this.next.clone();
            }
            return var1_1;
        }
    }
}

