/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTStore;
import org.apache.lucene.util.fst.ReverseBytesReader;

public final class OnHeapFSTStore
implements FSTStore {
    private BytesStore bytes;
    private byte[] bytesArray;
    private final int maxBlockBits;

    /*
     * WARNING - void declaration
     */
    public OnHeapFSTStore(int maxBlockBits) {
        void var1_1;
        if (maxBlockBits <= 0 || maxBlockBits > 30) {
            throw new IllegalArgumentException("maxBlockBits should be 1 .. 30; got " + maxBlockBits);
        }
        this.maxBlockBits = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void init(DataInput in, long numBytes) throws IOException {
        void var1_1;
        void var2_2;
        if (numBytes > (long)(1 << this.maxBlockBits)) {
            this.bytes = new BytesStore(in, numBytes, 1 << this.maxBlockBits);
            return;
        }
        this.bytesArray = new byte[(int)var2_2];
        var1_1.readBytes(this.bytesArray, 0, this.bytesArray.length);
    }

    @Override
    public final FST.BytesReader getReverseBytesReader() {
        if (this.bytesArray != null) {
            return new ReverseBytesReader(this.bytesArray);
        }
        return this.bytes.getReverseReader();
    }

    static {
        OnHeapFSTStore.class.desiredAssertionStatus();
        RamUsageEstimator.shallowSizeOfInstance(OnHeapFSTStore.class);
    }
}

