/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

import com.whitemagicsoftware.keenquotes.lex.FilterType;
import com.whitemagicsoftware.keenquotes.parser.AmbiguityResolver;
import com.whitemagicsoftware.keenquotes.parser.Contractions;
import com.whitemagicsoftware.keenquotes.parser.Token;
import com.whitemagicsoftware.keenquotes.parser.TokenType;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;

public class Curler
implements Function<String, String> {
    public static final Map<TokenType, String> ENTITIES = Map.ofEntries(Map.entry(TokenType.QUOTE_OPENING_SINGLE, "&lsquo;"), Map.entry(TokenType.QUOTE_CLOSING_SINGLE, "&rsquo;"), Map.entry(TokenType.QUOTE_OPENING_DOUBLE, "&ldquo;"), Map.entry(TokenType.QUOTE_CLOSING_DOUBLE, "&rdquo;"), Map.entry(TokenType.QUOTE_STRAIGHT_SINGLE, "'"), Map.entry(TokenType.QUOTE_STRAIGHT_DOUBLE, "\""), Map.entry(TokenType.QUOTE_APOSTROPHE, "&apos;"), Map.entry(TokenType.QUOTE_PRIME_SINGLE, "&prime;"), Map.entry(TokenType.QUOTE_PRIME_DOUBLE, "&Prime;"), Map.entry(TokenType.QUOTE_PRIME_TRIPLE, "&tprime;"), Map.entry(TokenType.QUOTE_PRIME_QUADRUPLE, "&qprime;"));
    public static final Map<TokenType, String> CHARS = Map.ofEntries(Map.entry(TokenType.QUOTE_OPENING_SINGLE, "\u2018"), Map.entry(TokenType.QUOTE_CLOSING_SINGLE, "\u2019"), Map.entry(TokenType.QUOTE_OPENING_DOUBLE, "\u201c"), Map.entry(TokenType.QUOTE_CLOSING_DOUBLE, "\u201d"), Map.entry(TokenType.QUOTE_STRAIGHT_SINGLE, "'"), Map.entry(TokenType.QUOTE_STRAIGHT_DOUBLE, "\""), Map.entry(TokenType.QUOTE_APOSTROPHE, "\u2019"), Map.entry(TokenType.QUOTE_PRIME_SINGLE, "\u2032"), Map.entry(TokenType.QUOTE_PRIME_DOUBLE, "\u2033"), Map.entry(TokenType.QUOTE_PRIME_TRIPLE, "\u2034"), Map.entry(TokenType.QUOTE_PRIME_QUADRUPLE, "\u2057"));
    private final Contractions mContractions;
    private final Map<TokenType, String> mReplacements;
    private final FilterType mFilterType;

    public Curler(Contractions c, FilterType parserType) {
        this(c, ENTITIES, parserType);
    }

    public Curler(Contractions c, Map<TokenType, String> replacements, FilterType parserType) {
        this.mContractions = c;
        this.mReplacements = replacements;
        this.mFilterType = parserType;
    }

    @Override
    public String apply(String text) {
        StringBuilder output = new StringBuilder(text);
        AtomicInteger offset = new AtomicInteger(0);
        AmbiguityResolver.resolve(text, this.mContractions, Curler.replace(output, offset, this.mReplacements), this.mFilterType.filter());
        return output.toString();
    }

    public static Consumer<Token> replace(StringBuilder output, AtomicInteger offset, Map<TokenType, String> replacements) {
        return token -> {
            if (!token.isAmbiguous()) {
                String entity = token.toString(replacements);
                output.replace(token.began() + offset.get(), token.ended() + offset.get(), entity);
                offset.addAndGet(entity.length() - (token.ended() - token.began()));
            }
        };
    }
}

