/*
 * Decompiled with CFR 0.152.
 */
package com.panemu.tiwulfx.control.dock;

import com.panemu.tiwulfx.control.dock.DetachableTab;
import com.panemu.tiwulfx.control.dock.DetachableTabPaneFactory;
import com.panemu.tiwulfx.control.dock.TabDropHint;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.skin.TabPaneSkin;
import javafx.scene.image.Image;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class DetachableTabPane
extends TabPane {
    private static DetachableTabPane DRAG_SOURCE;
    private static Tab DRAGGED_TAB;
    private final StringProperty scope = new SimpleStringProperty("");
    private TabDropHint dropHint = new TabDropHint();
    private Pos pos;
    private int dropIndex;
    private final List<Double> lstTabPoint = new ArrayList<Double>();
    private boolean closeIfEmpty;
    private StackPane btnBottom;
    private StackPane btnLeft;
    private StackPane btnTop;
    private StackPane btnRight;
    private StackPane dockPosIndicator;
    private static final DataFormat DATA_FORMAT;
    private Consumer<DetachableTabPane> siblingProvider;
    private static final int STAGE_WIDTH = 400;
    private Callback<DetachableTabPane, Scene> sceneFactory = p -> new Scene((Parent)p, 400.0, 400.0);
    private DetachableTabPaneFactory detachableTabPaneFactory = new DetachableTabPaneFactory(){

        @Override
        protected void init(DetachableTabPane a) {
        }
    };
    private Callback<Stage, Window> stageOwnerFactory = p -> {
        if (this.getScene() == null) {
            return null;
        }
        return this.getScene().getWindow();
    };

    public DetachableTabPane() {
        this.getStyleClass().add((Object)"detachable-tab-pane");
        this.attachListeners();
    }

    private void initDropButton() {
        this.btnTop = new StackPane();
        this.btnTop.getStyleClass().addAll((Object[])new String[]{"adjacent-drop", "drop-top"});
        this.btnRight = new StackPane();
        this.btnRight.getStyleClass().addAll((Object[])new String[]{"adjacent-drop", "drop-right"});
        this.btnLeft = new StackPane();
        this.btnLeft.getStyleClass().addAll((Object[])new String[]{"adjacent-drop", "drop-left"});
        this.btnBottom = new StackPane();
        this.btnBottom.getStyleClass().addAll((Object[])new String[]{"adjacent-drop", "drop-bottom"});
        StackPane.setAlignment((Node)this.btnTop, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)this.btnRight, (Pos)Pos.CENTER_RIGHT);
        StackPane.setAlignment((Node)this.btnBottom, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setAlignment((Node)this.btnLeft, (Pos)Pos.CENTER_LEFT);
        StackPane wrapper = new StackPane();
        wrapper.getStyleClass().setAll((Object[])new String[]{"dock-pos-indicator"});
        wrapper.getChildren().addAll((Object[])new Node[]{this.btnBottom, this.btnLeft, this.btnTop, this.btnRight});
        this.dockPosIndicator = new StackPane();
        this.dockPosIndicator.getChildren().add((Object)wrapper);
    }

    public String getScope() {
        return (String)this.scope.get();
    }

    public void setScope(String scope) {
        this.scope.set((Object)scope);
    }

    public StringProperty scopeProperty() {
        return this.scope;
    }

    public DetachableTab addTab(String tabName, Node content) {
        DetachableTab tab = new DetachableTab(tabName, content);
        this.getTabs().add((Object)tab);
        return tab;
    }

    private void attachListeners() {
        this.sceneProperty().addListener((ov, t, t1) -> {
            if (t == null && t1 != null) {
                if (this.getScene().getWindow() != null) {
                    Platform.runLater(() -> this.initiateDragGesture(true));
                } else {
                    this.getScene().windowProperty().addListener((ov1, t2, t3) -> {
                        if (t2 == null && t3 != null) {
                            t3.addEventHandler(WindowEvent.WINDOW_SHOWN, t4 -> this.initiateDragGesture(true));
                        }
                    });
                }
            }
        });
        this.addEventHandler(DragEvent.ANY, event -> {
            if (DRAG_SOURCE == null) {
                return;
            }
            if (event.getEventType() == DragEvent.DRAG_OVER) {
                if (((String)this.scope.get()).equals(DRAG_SOURCE.getScope())) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                    this.repaintPath((DragEvent)event);
                }
                event.consume();
            } else if (event.getEventType() == DragEvent.DRAG_EXITED) {
                if (this.getSkin() instanceof TabPaneSkin) {
                    TabPaneSkin sp = (TabPaneSkin)this.getSkin();
                    sp.getChildren().remove((Object)this.dropHint.getPath());
                    sp.getChildren().remove((Object)this.dockPosIndicator);
                    this.requestLayout();
                }
            } else if (event.getEventType() == DragEvent.DRAG_ENTERED) {
                TabPaneSkin sp;
                if (!((String)this.scope.get()).equals(DRAG_SOURCE.getScope())) {
                    return;
                }
                this.calculateTabPoints();
                if (this.dockPosIndicator == null) {
                    this.initDropButton();
                }
                double layoutX = this.getWidth() / 2.0;
                double layoutY = this.getHeight() / 2.0;
                this.dockPosIndicator.setLayoutX(layoutX);
                this.dockPosIndicator.setLayoutY(layoutY);
                if (this.getSkin() instanceof TabPaneSkin && !(sp = (TabPaneSkin)this.getSkin()).getChildren().contains((Object)this.dropHint.getPath())) {
                    if (!this.getTabs().isEmpty()) {
                        sp.getChildren().add((Object)this.dockPosIndicator);
                    }
                    this.repaintPath((DragEvent)event);
                    sp.getChildren().add((Object)this.dropHint.getPath());
                }
            } else if (event.getEventType() == DragEvent.DRAG_DROPPED) {
                if (this.pos != null) {
                    this.adjacent();
                    event.setDropCompleted(true);
                    event.consume();
                    return;
                }
                if (DRAG_SOURCE != this) {
                    Tab selectedtab = DRAGGED_TAB;
                    this.getTabs().add(this.dropIndex, (Object)selectedtab);
                    Platform.runLater(() -> this.getSelectionModel().select((Object)selectedtab));
                    event.setDropCompleted(true);
                } else {
                    event.setDropCompleted(true);
                    Tab selectedtab = DRAGGED_TAB;
                    int currentSelectionIndex = this.getTabs().indexOf((Object)selectedtab);
                    if (this.dropIndex == currentSelectionIndex) {
                        return;
                    }
                    this.getTabs().add(this.dropIndex, (Object)selectedtab);
                    Platform.runLater(() -> this.getSelectionModel().select((Object)selectedtab));
                }
                if (event.isDropCompleted()) {
                    event.getDragboard().setContent(null);
                }
                event.consume();
            }
        });
        this.getTabs().addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    if (this.getScene() == null || this.getScene().getWindow() == null || !this.getScene().getWindow().isShowing()) continue;
                    Platform.runLater(() -> {
                        this.clearGesture();
                        this.initiateDragGesture(true);
                        this.futureCalculateTabPoints();
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                this.futureCalculateTabPoints();
                if (DRAG_SOURCE != null) continue;
                if (this.getScene() != null && this.getScene().getWindow() instanceof TabStage) {
                    TabStage stage = (TabStage)this.getScene().getWindow();
                    this.closeStageIfNeeded(stage);
                }
                if (!this.getTabs().isEmpty()) continue;
                this.removeFromParent(this);
            }
        });
    }

    private SplitPane findParentSplitPane(Node control) {
        if (control.getParent() == null) {
            return null;
        }
        Set lstSplitpane = control.getScene().getRoot().lookupAll(".split-pane");
        SplitPane parentSplitpane = null;
        for (Node node : lstSplitpane) {
            SplitPane splitpane;
            if (!(node instanceof SplitPane) || !(splitpane = (SplitPane)node).getItems().contains((Object)control)) continue;
            parentSplitpane = splitpane;
            break;
        }
        return parentSplitpane;
    }

    private void adjacent() {
        SplitPane targetSplitPane = this.findParentSplitPane((Node)this);
        Tab selectedtab = DRAGGED_TAB;
        if (this.getParent() == null) {
            Scene scene = this.getScene();
            StackPane wrapper = new StackPane();
            wrapper.getChildren().add((Object)this);
            scene.setRoot((Parent)wrapper);
        }
        Parent parent = this.getParent();
        Orientation requestedOrientation = Orientation.HORIZONTAL;
        if (this.pos == Pos.BOTTOM_CENTER || this.pos == Pos.TOP_CENTER) {
            requestedOrientation = Orientation.VERTICAL;
        }
        int requestedIndex = 0;
        if (targetSplitPane != null && requestedOrientation == targetSplitPane.getOrientation()) {
            requestedIndex = targetSplitPane.getItems().indexOf((Object)this);
        }
        if (this.pos == Pos.CENTER_RIGHT || this.pos == Pos.BOTTOM_CENTER) {
            ++requestedIndex;
        }
        if (targetSplitPane == null) {
            targetSplitPane = new SplitPane();
            targetSplitPane.setOrientation(requestedOrientation);
            if (parent instanceof Pane) {
                Pane pane = (Pane)parent;
                int index = pane.getChildren().indexOf((Object)this);
                pane.getChildren().remove((Object)this);
                pane.getChildren().add(index, (Object)targetSplitPane);
                targetSplitPane.getItems().add((Object)this);
                DetachableTabPane dt = this.detachableTabPaneFactory.create(this);
                dt.getTabs().add((Object)selectedtab);
                targetSplitPane.getItems().add(requestedIndex, (Object)dt);
            }
        } else {
            if (targetSplitPane.getItems().size() == 1) {
                targetSplitPane.setOrientation(requestedOrientation);
            }
            if (targetSplitPane.getOrientation() == requestedOrientation) {
                DetachableTabPane dt = this.detachableTabPaneFactory.create(this);
                dt.getTabs().add((Object)selectedtab);
                targetSplitPane.getItems().add(requestedIndex, (Object)dt);
                int itemCount = targetSplitPane.getItems().size();
                double[] dividerPos = new double[itemCount];
                dividerPos[0] = 1.0 / (double)itemCount;
                for (int i = 1; i < dividerPos.length; ++i) {
                    dividerPos[i] = dividerPos[i - 1] + dividerPos[0];
                }
                targetSplitPane.setDividerPositions(dividerPos);
            } else {
                int indexTabPane = targetSplitPane.getItems().indexOf((Object)this);
                targetSplitPane.getItems().remove((Object)this);
                SplitPane innerSplitpane = new SplitPane();
                targetSplitPane.getItems().add(indexTabPane, (Object)innerSplitpane);
                innerSplitpane.setOrientation(requestedOrientation);
                innerSplitpane.getItems().add((Object)this);
                DetachableTabPane dt = this.detachableTabPaneFactory.create(this);
                dt.getTabs().add((Object)selectedtab);
                innerSplitpane.getItems().add(requestedIndex, (Object)dt);
            }
        }
    }

    private void futureCalculateTabPoints() {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DetachableTabPane.this.calculateTabPoints();
                timer.cancel();
                timer.purge();
            }
        }, 1000L);
    }

    private void initiateDragGesture(boolean retryOnFailed) {
        Node tabheader = this.getTabHeaderArea();
        if (tabheader == null) {
            if (retryOnFailed) {
                final Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        DetachableTabPane.this.initiateDragGesture(false);
                        timer.cancel();
                        timer.purge();
                    }
                }, 500L);
            }
            return;
        }
        Set tabs = tabheader.lookupAll(".tab");
        for (Node node : tabs) {
            this.addGesture(this, node);
        }
    }

    private Node getTabHeaderArea() {
        Node tabheader = null;
        for (Node node : this.getChildrenUnmodifiable()) {
            if (!node.getStyleClass().contains((Object)"tab-header-area")) continue;
            tabheader = node;
            break;
        }
        return tabheader;
    }

    private void calculateTabPoints() {
        this.lstTabPoint.clear();
        this.lstTabPoint.add(0.0);
        Node tabheader = this.getTabHeaderArea();
        if (tabheader == null) {
            return;
        }
        Set tabs = tabheader.lookupAll(".tab");
        Point2D inset = this.localToScene(0.0, 0.0);
        for (Node node : tabs) {
            Point2D point = node.localToScene(0.0, 0.0);
            Bounds bound = node.getLayoutBounds();
            this.lstTabPoint.add(point.getX() + bound.getWidth() - inset.getX());
        }
    }

    private void repaintPath(DragEvent event) {
        boolean hasTab;
        boolean bl = hasTab = !this.getTabs().isEmpty();
        if (hasTab && this.btnLeft.contains(this.btnLeft.screenToLocal(event.getScreenX(), event.getScreenY()))) {
            this.dropHint.refresh(0.0, 0.0, this.getWidth() / 2.0, this.getHeight());
            this.pos = Pos.CENTER_LEFT;
        } else if (hasTab && this.btnRight.contains(this.btnRight.screenToLocal(event.getScreenX(), event.getScreenY()))) {
            double pathWidth = this.getWidth() / 2.0;
            this.dropHint.refresh(pathWidth, 0.0, pathWidth, this.getHeight());
            this.pos = Pos.CENTER_RIGHT;
        } else if (hasTab && this.btnTop.contains(this.btnTop.screenToLocal(event.getScreenX(), event.getScreenY()))) {
            this.dropHint.refresh(0.0, 0.0, this.getWidth(), this.getHeight() / 2.0);
            this.pos = Pos.TOP_CENTER;
        } else if (hasTab && this.btnBottom.contains(this.btnBottom.screenToLocal(event.getScreenX(), event.getScreenY()))) {
            double pathHeight = this.getHeight() / 2.0;
            this.dropHint.refresh(0.0, pathHeight, this.getWidth(), this.getHeight() - pathHeight);
            this.pos = Pos.BOTTOM_CENTER;
        } else {
            this.pos = null;
            double tabpos = -1.0;
            for (int i = 1; i < this.lstTabPoint.size(); ++i) {
                if (!(event.getX() < this.lstTabPoint.get(i))) continue;
                tabpos = this.lstTabPoint.get(i - 1);
                this.dropIndex = i - 1;
                break;
            }
            if (tabpos == -1.0) {
                int index = this.lstTabPoint.size() - 1;
                this.dropIndex = this.getTabs().size();
                if (index > -1) {
                    tabpos = this.lstTabPoint.get(index);
                }
            }
            this.dropHint.refresh(tabpos, this.getWidth(), this.getHeight());
        }
    }

    private void clearGesture() {
        Node tabheader = this.getTabHeaderArea();
        if (tabheader == null) {
            return;
        }
        Set tabs = tabheader.lookupAll(".tab");
        for (Node node : tabs) {
            node.setOnDragDetected(null);
            node.setOnDragDone(null);
        }
    }

    private void addGesture(TabPane tabPane, Node node) {
        node.setOnDragDetected(e -> {
            Tab tab = (Tab)tabPane.getSelectionModel().getSelectedItem();
            if (tab instanceof DetachableTab && !((DetachableTab)tab).isDetachable()) {
                return;
            }
            Dragboard db = node.startDragAndDrop(TransferMode.ANY);
            db.setDragView((Image)node.snapshot(null, null), -20.0, 0.0);
            HashMap<DataFormat, String> dragContent = new HashMap<DataFormat, String>();
            dragContent.put(DATA_FORMAT, "test");
            DRAG_SOURCE = this;
            DRAGGED_TAB = tab;
            this.getTabs().remove((Object)DRAGGED_TAB);
            db.setContent(dragContent);
            e.consume();
        });
        node.setOnDragDone(event -> {
            if (DRAGGED_TAB != null && DRAGGED_TAB.getTabPane() == null) {
                Tab tab = DRAGGED_TAB;
                new TabStage(tab);
            }
            if (DRAG_SOURCE.getScene() != null && DRAG_SOURCE.getScene().getWindow() instanceof TabStage) {
                TabStage stage = (TabStage)DRAG_SOURCE.getScene().getWindow();
                this.closeStageIfNeeded(stage);
            }
            if (DRAG_SOURCE.getTabs().isEmpty()) {
                this.removeFromParent(DRAG_SOURCE);
            }
            DRAG_SOURCE = null;
            DRAGGED_TAB = null;
            event.consume();
        });
    }

    private void closeStageIfNeeded(TabStage stage) {
        Set setNode = stage.getScene().getRoot().lookupAll(".tab-pane");
        boolean empty = true;
        for (Node nodeTabpane : setNode) {
            if (!(nodeTabpane instanceof DetachableTabPane) || ((DetachableTabPane)nodeTabpane).getTabs().isEmpty()) continue;
            empty = false;
            break;
        }
        if (empty) {
            Set setSplitpane = stage.getScene().getRoot().lookupAll(".split-pane");
            for (Node nodeSplitpane : setSplitpane) {
                if (nodeSplitpane instanceof SplitPane) {
                    SplitPane asplitpane = (SplitPane)nodeSplitpane;
                    for (Node child : asplitpane.getItems()) {
                        DetachableTabPane dtp;
                        if (!(child instanceof DetachableTabPane) || (dtp = (DetachableTabPane)child).getTabs().isEmpty()) continue;
                        empty = false;
                        break;
                    }
                }
                if (empty) continue;
                break;
            }
        }
        if (empty) {
            stage.close();
        }
    }

    private void removeFromParent(DetachableTabPane tabPaneToRemove) {
        SplitPane sp = this.findParentSplitPane((Node)tabPaneToRemove);
        if (sp == null) {
            return;
        }
        if (!tabPaneToRemove.isCloseIfEmpty()) {
            DetachableTabPane sibling = this.findSibling(sp, tabPaneToRemove);
            if (sibling == null) {
                return;
            }
            sibling.setCloseIfEmpty(false);
            if (this.siblingProvider != null) {
                this.siblingProvider.accept(sibling);
                sibling.setOnClosedPassSibling(this.siblingProvider);
            }
        }
        sp.getItems().remove((Object)tabPaneToRemove);
        this.simplifySplitPane(sp);
    }

    public void setOnClosedPassSibling(Consumer<DetachableTabPane> siblingProvider) {
        this.siblingProvider = siblingProvider;
    }

    private DetachableTabPane findSibling(SplitPane sp, DetachableTabPane tabPaneToRemove) {
        for (Node sibling : sp.getItems()) {
            if (tabPaneToRemove == sibling || !(sibling instanceof DetachableTabPane) || !tabPaneToRemove.getScope().equals(((DetachableTabPane)sibling).getScope())) continue;
            return (DetachableTabPane)sibling;
        }
        for (Node sibling : sp.getItems()) {
            if (!(sibling instanceof SplitPane)) continue;
            return this.findSibling((SplitPane)sibling, tabPaneToRemove);
        }
        return null;
    }

    private void simplifySplitPane(SplitPane sp) {
        if (sp.getItems().size() != 1) {
            return;
        }
        Node content = (Node)sp.getItems().get(0);
        SplitPane parent = this.findParentSplitPane((Node)sp);
        if (parent != null) {
            int index = parent.getItems().indexOf((Object)sp);
            parent.getItems().remove((Object)sp);
            parent.getItems().add(index, (Object)content);
            this.simplifySplitPane(parent);
        }
    }

    public void setSceneFactory(Callback<DetachableTabPane, Scene> sceneFactory) {
        this.sceneFactory = sceneFactory;
    }

    public Callback<DetachableTabPane, Scene> getSceneFactory() {
        return this.sceneFactory;
    }

    public void setStageOwnerFactory(Callback<Stage, Window> stageOwnerFactory) {
        this.stageOwnerFactory = stageOwnerFactory;
    }

    public Callback<Stage, Window> getStageOwnerFactory() {
        return this.stageOwnerFactory;
    }

    public boolean isCloseIfEmpty() {
        return this.closeIfEmpty;
    }

    public void setCloseIfEmpty(boolean closeIfEmpty) {
        this.closeIfEmpty = closeIfEmpty;
    }

    public DetachableTabPaneFactory getDetachableTabPaneFactory() {
        return this.detachableTabPaneFactory;
    }

    public void setDetachableTabPaneFactory(DetachableTabPaneFactory detachableTabPaneFactory) {
        if (detachableTabPaneFactory == null) {
            throw new NullPointerException("detachableTabPaneFactory");
        }
        this.detachableTabPaneFactory = detachableTabPaneFactory;
    }

    public String getUserAgentStylesheet() {
        return DetachableTabPane.class.getResource("tiwulfx-dock.css").toExternalForm();
    }

    public void setDropHint(TabDropHint dropHint) {
        this.dropHint = dropHint;
    }

    public TabDropHint getDropHint() {
        return this.dropHint;
    }

    static {
        DATA_FORMAT = new DataFormat(new String[]{"dragAwareTab"});
    }

    private class TabStage
    extends Stage {
        public TabStage(Tab tab) {
            DetachableTabPane tabPane = DetachableTabPane.this.detachableTabPaneFactory.create(DetachableTabPane.this);
            this.initOwner((Window)DetachableTabPane.this.stageOwnerFactory.call((Object)this));
            Scene scene = (Scene)DetachableTabPane.this.sceneFactory.call((Object)tabPane);
            scene.getStylesheets().addAll((Collection)DetachableTabPane.this.getScene().getStylesheets());
            this.setScene(scene);
            Point p = MouseInfo.getPointerInfo().getLocation();
            this.setX(p.x - 200);
            this.setY(p.y);
            this.show();
            tabPane.getTabs().add((Object)tab);
            tabPane.getSelectionModel().select((Object)tab);
            if (tab.getContent() instanceof Parent) {
                ((Parent)tab.getContent()).requestLayout();
            }
        }
    }
}

