/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.lex;

import com.whitemagicsoftware.keenquotes.lex.LexerFilter;
import com.whitemagicsoftware.keenquotes.util.FastCharacterIterator;
import java.util.Set;

public final class XmlFilter
implements LexerFilter {
    private final Set<String> UNTOUCHABLE = Set.of("pre", "code", "tt", "tex", "kbd", "samp", "var", "l", "blockcode");

    @Override
    public boolean test(FastCharacterIterator i) {
        String openingTag;
        boolean match;
        boolean bl = match = i.current() == '<';
        if (match && this.UNTOUCHABLE.contains((openingTag = this.nextTag(i)).toLowerCase())) {
            String closingTag;
            while (!(closingTag = this.nextTag(i)).endsWith(openingTag)) {
            }
        }
        return match;
    }

    private String nextTag(FastCharacterIterator i) {
        int begin = i.index();
        i.skip(next -> next.charValue() != '>' && next.charValue() != '<');
        i.next();
        i.next();
        return i.substring(begin + 1, i.index() - 1);
    }
}

