/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.Char;
import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.atoms.AccentedAtom;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.CharSymbolAtom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.atoms.SymbolAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.CharBox;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;

public class ScriptsAtom
extends Atom {
    private static final SpaceAtom SCRIPT_SPACE = new SpaceAtom(3, 0.5f, 0.0f, 0.0f);
    private final Atom base;
    private final Atom subscript;
    private final Atom superscript;

    /*
     * WARNING - void declaration
     */
    public ScriptsAtom(Atom base, Atom sub, Atom sup) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.base = var1_1;
        this.subscript = var2_2;
        this.superscript = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Box createBox(TeXEnvironment env) {
        float shiftDown22;
        float shiftUp;
        Box b;
        Box box = b = this.base == null ? new StrutBox() : this.base.createBox(env);
        if (this.subscript == null && this.superscript == null) {
            return b;
        }
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        HorizontalBox hor = new HorizontalBox(b);
        int lastFontId = b.getLastFontId();
        if (lastFontId == -1) {
            lastFontId = tf.getMuFontId();
        }
        TeXEnvironment subStyle = env.subStyle();
        TeXEnvironment supStyle = env.supStyle();
        float delta = 0.0f;
        if (this.base instanceof AccentedAtom) {
            Box box2 = ((AccentedAtom)this.base).base.createBox(env.crampStyle());
            shiftUp = box2.getHeight() - tf.getSupDrop(supStyle.getStyle());
            shiftDown22 = box2.getDepth() + tf.getSubDrop(subStyle.getStyle());
        } else if (this.base instanceof SymbolAtom && this.base.type == 1) {
            float f;
            Char c = tf.getChar(((SymbolAtom)this.base).getName(), style);
            if (style < 2 && tf.hasNextLarger(c)) {
                c = tf.getNextLarger(c, style);
            }
            CharBox x = new CharBox(c);
            x.setShift(-(x.getHeight() + x.getDepth()) / 2.0f - env.getTeXFont().getAxisHeight(env.getStyle()));
            hor = new HorizontalBox(x);
            delta = c.getItalic();
            if (f > 1.0E-7f && this.subscript == null) {
                hor.add(new StrutBox(delta));
            }
            shiftUp = hor.getHeight() - tf.getSupDrop(supStyle.getStyle());
            shiftDown22 = hor.getDepth() + tf.getSubDrop(subStyle.getStyle());
        } else if (this.base instanceof CharSymbolAtom) {
            shiftDown22 = 0.0f;
            shiftUp = 0.0f;
            CharFont cf = ((CharSymbolAtom)this.base).getCharFont(tf);
            if (!((CharSymbolAtom)this.base).isMarkedAsTextSymbol() || !tf.hasSpace(cf.fontId)) {
                delta = tf.getChar(cf, style).getItalic();
            }
            if (delta > 1.0E-7f && this.subscript == null) {
                hor.add(new StrutBox(delta));
                delta = 0.0f;
            }
        } else {
            void shiftDown22;
            shiftUp = shiftDown22.getHeight() - tf.getSupDrop(supStyle.getStyle());
            shiftDown22 = shiftDown22.getDepth() + tf.getSubDrop(subStyle.getStyle());
        }
        if (this.superscript == null) {
            x = this.subscript.createBox(subStyle);
            x.setShift(Math.max(Math.max(shiftDown22, tf.getSub1(style)), x.getHeight() - 4.0f * Math.abs(tf.getXHeight(style, lastFontId)) / 5.0f));
            hor.add(x);
            hor.add(SCRIPT_SPACE.createBox(env));
        } else {
            x = this.superscript.createBox(supStyle);
            HorizontalBox sup = new HorizontalBox(x);
            sup.add(SCRIPT_SPACE.createBox(env));
            float p = style == 0 ? tf.getSup1(style) : (env.crampStyle().getStyle() == style ? tf.getSup3(style) : tf.getSup2(style));
            shiftUp = Math.max(Math.max(shiftUp, p), x.getDepth() + Math.abs(tf.getXHeight(style, lastFontId)) / 4.0f);
            if (this.subscript == null) {
                sup.setShift(-shiftUp);
                hor.add(sup);
            } else {
                void var1_3;
                void var2_5;
                float f;
                Box y = this.subscript.createBox(subStyle);
                HorizontalBox sub = new HorizontalBox(y);
                sub.add(SCRIPT_SPACE.createBox(env));
                shiftDown22 = Math.max(shiftDown22, tf.getSub2(style));
                float drt = tf.getDefaultRuleThickness(style);
                float interSpace = shiftUp - x.getDepth() + shiftDown22 - y.getHeight();
                if (f < 4.0f * drt) {
                    float f2;
                    void var3_6;
                    float psi = 4.0f * Math.abs(var3_6.getXHeight(style, lastFontId)) / 5.0f - ((shiftUp += 4.0f * drt - interSpace) - x.getDepth());
                    if (f2 > 0.0f) {
                        shiftUp += psi;
                        shiftDown22 -= psi;
                    }
                }
                VerticalBox vBox = new VerticalBox();
                sup.setShift(delta);
                vBox.add(sup);
                interSpace = shiftUp - x.getDepth() + shiftDown22 - y.getHeight();
                vBox.add(new StrutBox(0.0f, interSpace, 0.0f, 0.0f));
                vBox.add(sub);
                vBox.setHeight(shiftUp + x.getHeight());
                vBox.setDepth((float)(var2_5 + y.getDepth()));
                hor.add((Box)var1_3);
            }
        }
        return hor;
    }

    @Override
    public int getLeftType() {
        return this.base.getLeftType();
    }

    @Override
    public int getRightType() {
        return this.base.getRightType();
    }
}

