/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;

public class UnderOverAtom
extends Atom {
    private final Atom base;
    private final Atom under;
    private final Atom over;
    private final float underSpace;
    private final float overSpace;
    private final int overUnit;
    private final boolean underScriptSize;
    private final boolean overScriptSize;

    /*
     * WARNING - void declaration
     */
    public UnderOverAtom(Atom base, Atom underOver, int underOverUnit, float underOverSpace, boolean underOverScriptSize, boolean over) {
        void var2_2;
        void var1_1;
        SpaceAtom.checkUnit(underOverUnit);
        this.base = var1_1;
        if (over) {
            void var3_3;
            this.under = null;
            this.underSpace = 0.0f;
            this.underScriptSize = false;
            this.over = underOver;
            this.overUnit = var3_3;
            this.overSpace = underOverSpace;
            this.overScriptSize = underOverScriptSize;
            return;
        }
        this.under = var2_2;
        this.underSpace = underOverSpace;
        this.underScriptSize = underOverScriptSize;
        this.overSpace = 0.0f;
        this.over = null;
        this.overUnit = 0;
        this.overScriptSize = false;
    }

    /*
     * WARNING - void declaration
     */
    public UnderOverAtom(Atom base, Atom under, int underUnit, float underSpace, boolean underScriptSize, Atom over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        void var2_2;
        void var1_1;
        void var3_3;
        SpaceAtom.checkUnit((int)var3_3);
        SpaceAtom.checkUnit(overUnit);
        this.base = var1_1;
        this.under = var2_2;
        this.underSpace = underSpace;
        this.underScriptSize = underScriptSize;
        this.over = over;
        this.overUnit = overUnit;
        this.overSpace = overSpace;
        this.overScriptSize = overScriptSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Box createBox(TeXEnvironment env) {
        void var2_3;
        Box b = this.base == null ? new StrutBox() : this.base.createBox(env);
        Box o = null;
        Box u = null;
        float max = b.getWidth();
        if (this.over != null) {
            o = this.over.createBox(this.overScriptSize ? env.subStyle() : env);
            max = Math.max(max, o.getWidth());
        }
        if (this.under != null) {
            u = this.under.createBox(this.underScriptSize ? env.subStyle() : env);
            max = Math.max(max, u.getWidth());
        }
        VerticalBox vBox = new VerticalBox();
        env.setLastFontId(b.getLastFontId());
        if (this.over != null) {
            void var3_4;
            vBox.add(UnderOverAtom.changeWidth((Box)var3_4, max));
            vBox.add(new SpaceAtom(this.overUnit, 0.0f, this.overSpace, 0.0f).createBox(env));
        }
        vBox.add(UnderOverAtom.changeWidth(b, max));
        float h = vBox.getHeight() + vBox.getDepth() - b.getDepth();
        if (this.under != null) {
            void var1_1;
            vBox.add(new SpaceAtom(this.overUnit, 0.0f, this.underSpace, 0.0f).createBox((TeXEnvironment)var1_1));
            vBox.add(UnderOverAtom.changeWidth(u, max));
        }
        VerticalBox verticalBox = vBox;
        verticalBox.setDepth(verticalBox.getHeight() + vBox.getDepth() - h);
        vBox.setHeight((float)var2_3);
        return vBox;
    }

    /*
     * WARNING - void declaration
     */
    private static Box changeWidth(Box b, float maxWidth) {
        Box box;
        if (b != null && Math.abs(maxWidth - b.getWidth()) > 1.0E-7f) {
            void var1_1;
            return new HorizontalBox(b, (float)var1_1, 2);
        }
        return box;
    }
}

