/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.graphics;

import com.whitemagicsoftware.tex.graphics.AbstractGraphics2D;
import com.whitemagicsoftware.tex.graphics.RyuDouble;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public final class SvgGraphics2D
extends AbstractGraphics2D {
    private final StringBuilder mSvg;
    private final float[] mCoords = new float[6];
    private String mTransform = "";

    public SvgGraphics2D() {
        this(65536);
    }

    /*
     * WARNING - void declaration
     */
    public SvgGraphics2D(int initialBufferSize) {
        void var1_1;
        this.mSvg = new StringBuilder((int)var1_1).append("<svg xmlns='http://www.w3.org/2000/svg' version='1.1' ");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void initialize(int w, int h) {
        void var2_2;
        void var1_1;
        this.reset();
        this.appendDimensions((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void initialize(int id, int w, int h) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.reset();
        this.mSvg.append("id='").append((int)var1_1).append("' ");
        this.appendDimensions((int)var2_2, (int)var3_3);
    }

    @Override
    public final void draw(Shape shape) {
        SvgGraphics2D svgGraphics2D;
        this.mSvg.append("<g");
        if (!this.isIdentityTransform()) {
            this.mSvg.append(" transform='").append(this.mTransform).append('\'');
        }
        this.mSvg.append('>');
        Object object = (Path2D)((Object)svgGraphics2D);
        svgGraphics2D = this;
        svgGraphics2D.mSvg.append("<path ");
        if (((Path2D)object).getWindingRule() == 0) {
            svgGraphics2D.mSvg.append("fill-rule='evenodd' ");
        }
        svgGraphics2D.mSvg.append("d='");
        object = object.getPathIterator(null);
        while (!object.isDone()) {
            switch (object.currentSegment(svgGraphics2D.mCoords)) {
                case 0: {
                    double d = svgGraphics2D.mCoords[0];
                    double d2 = d;
                    d2 = svgGraphics2D.mCoords[1];
                    svgGraphics2D.mSvg.append('M').append(RyuDouble.doubleToString(d, 4)).append(' ').append(RyuDouble.doubleToString(d2, 4));
                    break;
                }
                case 1: {
                    double d = svgGraphics2D.mCoords[0];
                    double d2 = d;
                    d2 = svgGraphics2D.mCoords[1];
                    svgGraphics2D.mSvg.append('L').append(RyuDouble.doubleToString(d, 4)).append(' ').append(RyuDouble.doubleToString(d2, 4));
                    break;
                }
                case 2: {
                    double d = svgGraphics2D.mCoords[0];
                    double d2 = d;
                    double d3 = svgGraphics2D.mCoords[1];
                    d2 = d3;
                    double d4 = svgGraphics2D.mCoords[2];
                    d2 = d4;
                    d2 = svgGraphics2D.mCoords[3];
                    svgGraphics2D.mSvg.append('Q').append(RyuDouble.doubleToString(d, 4)).append(' ').append(RyuDouble.doubleToString(d3, 4)).append(' ').append(RyuDouble.doubleToString(d4, 4)).append(' ').append(RyuDouble.doubleToString(d2, 4));
                    break;
                }
                case 3: {
                    double d = svgGraphics2D.mCoords[0];
                    double d2 = d;
                    double d5 = svgGraphics2D.mCoords[1];
                    d2 = d5;
                    double d6 = svgGraphics2D.mCoords[2];
                    d2 = d6;
                    double d7 = svgGraphics2D.mCoords[3];
                    d2 = d7;
                    double d8 = svgGraphics2D.mCoords[4];
                    d2 = d8;
                    d2 = svgGraphics2D.mCoords[5];
                    svgGraphics2D.mSvg.append('C').append(RyuDouble.doubleToString(d, 4)).append(' ').append(RyuDouble.doubleToString(d5, 4)).append(' ').append(RyuDouble.doubleToString(d6, 4)).append(' ').append(RyuDouble.doubleToString(d7, 4)).append(' ').append(RyuDouble.doubleToString(d8, 4)).append(' ').append(RyuDouble.doubleToString(d2, 4));
                    break;
                }
                case 4: {
                    svgGraphics2D.mSvg.append('Z');
                }
            }
            object.next();
        }
        svgGraphics2D.mSvg.append("'/>");
        this.mSvg.append("</g>");
    }

    private void reset() {
        this.mSvg.setLength(54);
    }

    /*
     * WARNING - void declaration
     */
    private void appendDimensions(int w, int h) {
        void var2_2;
        void var1_1;
        this.mSvg.append("width='").append((int)var1_1).append("px' height='").append((int)var2_2).append("px'>");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void fill(Shape shape) {
        void var1_1;
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            double d = rect.getX();
            double d2 = d;
            double d3 = rect.getY();
            d2 = d3;
            double d4 = rect.getWidth();
            d2 = d4;
            d2 = var1_1.getHeight();
            this.mSvg.append("<rect x='").append(RyuDouble.doubleToString(d, 4)).append("' y='").append(RyuDouble.doubleToString(d3, 4)).append("' width='").append(RyuDouble.doubleToString(d4, 4)).append("' height='").append(RyuDouble.doubleToString(d2, 4));
            if (!this.isIdentityTransform()) {
                this.mSvg.append("' transform='").append(this.mTransform);
            }
            this.mSvg.append("'/>");
            return;
        }
        this.draw((Shape)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTransform(AffineTransform at) {
        void var1_1;
        assert (at != null);
        super.setTransform(at);
        this.mTransform = SvgGraphics2D.toString((AffineTransform)var1_1);
    }

    @Override
    public final String toString() {
        return this.mSvg.append("</svg>").toString();
    }
}

