/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.jdom2.Attribute;
import org.jdom2.AttributeList;
import org.jdom2.CloneBase;
import org.jdom2.Content;
import org.jdom2.ContentList;
import org.jdom2.DocType;
import org.jdom2.IllegalAddException;
import org.jdom2.IllegalNameException;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.Verifier;
import org.jdom2.filter.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Content
implements Parent {
    private String name;
    private Namespace namespace;
    private transient List<Namespace> additionalNamespaces = null;
    private transient AttributeList attributes = null;
    transient ContentList content = new ContentList(this);

    protected Element() {
        super(Content.CType.Element);
    }

    public Element(String name, Namespace namespace) {
        super(Content.CType.Element);
        Object object3;
        Element element;
        Namespace namespace2 = element;
        element = this;
        Object object2 = Verifier.checkElementName((String)((Object)namespace2));
        if (object2 != null) {
            throw new IllegalNameException((String)((Object)namespace2), "element", (String)object2);
        }
        element.name = namespace2;
        namespace2 = object3;
        element = this;
        if (namespace2 == null) {
            namespace2 = Namespace.NO_NAMESPACE;
        }
        if (element.additionalNamespaces != null && (object2 = Verifier.checkNamespaceCollision(namespace2, element.getAdditionalNamespaces())) != null) {
            throw new IllegalAddException(element, namespace2, (String)object2);
        }
        if (element.hasAttributes()) {
            object3 = element;
            for (Object object3 : ((Element)object3).getAttributeList()) {
                if ((object3 = Verifier.checkNamespaceCollision(namespace2, (Attribute)object3)) == null) continue;
                throw new IllegalAddException(element, namespace2, (String)object3);
            }
        }
        element.namespace = namespace2;
    }

    public final String getName() {
        return this.name;
    }

    public final Namespace getNamespace() {
        return this.namespace;
    }

    public final String getQualifiedName() {
        if ("".equals(this.namespace.getPrefix())) {
            Element element = this;
            return element.name;
        }
        return this.namespace.getPrefix() + ':' + this.name;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addNamespaceDeclaration(Namespace additionalNamespace) {
        void var1_1;
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList<Namespace>(5);
        }
        Iterator<Namespace> iterator = this.additionalNamespaces.iterator();
        while (iterator.hasNext()) {
            Namespace namespace = iterator.next();
            if (namespace != additionalNamespace) continue;
            return false;
        }
        String reason = Verifier.checkNamespaceCollision(additionalNamespace, this);
        if (reason != null) {
            throw new IllegalAddException(this, additionalNamespace, (String)((Object)iterator));
        }
        return this.additionalNamespaces.add((Namespace)var1_1);
    }

    public final List<Namespace> getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public final boolean isAncestor(Element element) {
        Parent p = element.getParent();
        while (p instanceof Element) {
            if (p == this) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public final boolean hasAdditionalNamespaces() {
        return this.additionalNamespaces != null && !this.additionalNamespaces.isEmpty();
    }

    final AttributeList getAttributeList() {
        if (this.attributes == null) {
            this.attributes = new AttributeList(this);
        }
        return this.attributes;
    }

    public final List<Attribute> getAttributes() {
        return this.getAttributeList();
    }

    public final String getAttributeValue(String attname) {
        CloneBase cloneBase;
        if (this.attributes == null) {
            return null;
        }
        Namespace namespace = Namespace.NO_NAMESPACE;
        void var2_3 = cloneBase;
        cloneBase = this;
        if (((Element)cloneBase).attributes == null) {
            return null;
        }
        String string = null;
        if (((Element)cloneBase).attributes == null) {
            return string;
        }
        if ((cloneBase = ((Element)cloneBase).getAttributeList().get((String)var2_3, namespace)) == null) {
            return string;
        }
        return ((Attribute)cloneBase).getValue();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder stringForm = new StringBuilder(64).append("[Element: <").append(this.getQualifiedName());
        Element element = this;
        String nsuri = element.namespace.getURI();
        if (!"".equals(nsuri)) {
            stringForm.append(" [Namespace: ").append((String)((Object)element)).append("]");
        }
        stringForm.append("/>]");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Element clone() {
        void var1_1;
        int i;
        Element element = (Element)super.clone();
        ((Element)super.clone()).content = new ContentList(element);
        AttributeList attributeList = element.attributes = this.attributes == null ? null : new AttributeList(element);
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.size(); ++i) {
                Attribute attribute = this.attributes.get(i);
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        for (i = 0; i < this.content.size(); ++i) {
            void var3_3;
            Content c = this.content.get(i);
            element.content.add(var3_3.clone());
        }
        return var1_1;
    }

    public final List<Element> getChildren() {
        return this.content.getView(new ElementFilter());
    }

    /*
     * WARNING - void declaration
     */
    public final List<Element> getChildren(String cname) {
        void var1_1;
        return this.getChildren((String)var1_1, Namespace.NO_NAMESPACE);
    }

    /*
     * WARNING - void declaration
     */
    private List<Element> getChildren(String cname, Namespace ns) {
        void var2_2;
        void var1_1;
        return this.content.getView(new ElementFilter((String)var1_1, (Namespace)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private Element getChild(String cname, Namespace ns) {
        void var2_2;
        Iterator<Element> iter = (cname = this.content.getView(new ElementFilter((String)cname, (Namespace)var2_2))).iterator();
        if (iter.hasNext()) {
            void var1_1;
            return (Element)var1_1.next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Element getChild(String cname) {
        void var1_1;
        return this.getChild((String)var1_1, Namespace.NO_NAMESPACE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Namespace> getNamespacesInScope() {
        void var3_3;
        void var1_1;
        Element pnt;
        Object ns;
        TreeMap<String, Object> namespaces = new TreeMap<String, Object>();
        namespaces.put(Namespace.XML_NAMESPACE.getPrefix(), Namespace.XML_NAMESPACE);
        Element element = this;
        Object object = element;
        object = this;
        namespaces.put(element.namespace.getPrefix(), ((Element)object).namespace);
        if (this.additionalNamespaces != null) {
            object = this.getAdditionalNamespaces().iterator();
            while (object.hasNext()) {
                ns = (Namespace)object.next();
                if (namespaces.containsKey(((Namespace)ns).getPrefix())) continue;
                namespaces.put(((Namespace)ns).getPrefix(), ns);
            }
        }
        if (this.attributes != null) {
            object = this;
            object = ((Element)object).getAttributeList().iterator();
            while (object.hasNext()) {
                ns = (Attribute)object.next();
                Namespace ns2 = ((Attribute)ns).getNamespace();
                if (Namespace.NO_NAMESPACE.equals(ns2) || namespaces.containsKey(ns2.getPrefix())) continue;
                namespaces.put(ns2.getPrefix(), ns2);
            }
        }
        if ((pnt = this.getParentElement()) != null) {
            for (Namespace ns2 : pnt.getNamespacesInScope()) {
                if (namespaces.containsKey(ns2.getPrefix())) continue;
                namespaces.put(ns2.getPrefix(), ns2);
            }
        }
        if (object == null && !namespaces.containsKey("")) {
            namespaces.put(Namespace.NO_NAMESPACE.getPrefix(), Namespace.NO_NAMESPACE);
        }
        ArrayList<Namespace> al = new ArrayList<Namespace>(namespaces.size());
        object = this;
        al.add(((Element)object).namespace);
        object = this;
        namespaces.remove(((Element)object).namespace.getPrefix());
        al.addAll(var1_1.values());
        return Collections.unmodifiableList(var3_3);
    }

    @Override
    public final void canContainContent(Content child, int index, boolean replace) throws IllegalAddException {
        if (child instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }
}

