/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.lex;

import com.whitemagicsoftware.keenquotes.lex.LexemeType;

public final class Lexeme
implements Comparable<Lexeme> {
    private static final int E_INDEX = -2;
    public static final Lexeme EOT = new Lexeme(LexemeType.EOT, -1, -2);
    public static final Lexeme SOT = new Lexeme(LexemeType.SOT, 0, -2);
    public static final Lexeme NONE = new Lexeme(LexemeType.NONE, 0, 0);
    private final LexemeType mType;
    private final int mBegan;
    private final int mEnded;

    public Lexeme(LexemeType type, int began, int ended) {
        assert (type != null);
        assert (began >= 0 || ended == -2);
        assert (began <= ended || ended == -2);
        this.mType = type;
        this.mBegan = began;
        this.mEnded = ended;
    }

    public Lexeme copy() {
        return new Lexeme(this.mType.copy(), this.mBegan, this.mEnded);
    }

    public boolean isType(LexemeType type) {
        assert (type != null);
        return !(this.mType == LexemeType.NONE && type != LexemeType.NONE || this.mType != type && type != LexemeType.ANY && (type != LexemeType.ENDING || this.mType != LexemeType.EOL && this.mType != LexemeType.EOP && this.mType != LexemeType.EOT));
    }

    public boolean isType(LexemeType ... types) {
        assert (types != null);
        for (LexemeType type : types) {
            if (!this.isType(type)) continue;
            return true;
        }
        return false;
    }

    public int began() {
        return this.mBegan;
    }

    public int ended() {
        return this.mEnded;
    }

    public LexemeType getType() {
        return this.mType;
    }

    @Override
    public int compareTo(Lexeme that) {
        assert (that != null);
        return this.mBegan - that.mBegan;
    }

    public String toString(String text) {
        assert (text != null);
        return text.substring(this.mBegan, this.mEnded).toLowerCase();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[mType=" + this.mType + ", mBegan=" + this.mBegan + ", mEnded=" + this.mEnded + "]";
    }
}

