/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.lex;

import com.whitemagicsoftware.keenquotes.lex.Lexeme;
import com.whitemagicsoftware.keenquotes.lex.LexemeGlyph;
import com.whitemagicsoftware.keenquotes.lex.LexemeType;
import com.whitemagicsoftware.keenquotes.lex.LexerFilter;
import com.whitemagicsoftware.keenquotes.util.FastCharacterIterator;
import java.util.function.Consumer;

public final class Lexer {
    public static void lex(String text, Consumer<Lexeme> emitter, LexerFilter filter) {
        Lexer.lex(new FastCharacterIterator(text), emitter, filter);
    }

    private static void lex(FastCharacterIterator i, Consumer<Lexeme> consumer, LexerFilter filter) {
        consumer.accept(Lexeme.SOT);
        while (i.hasNext()) {
            while (filter.test(i)) {
            }
            int index = i.index();
            char curr = i.current();
            LexemeType token = LexemeType.PUNCT;
            if (Lexer.isLetter(curr)) {
                i.skip(next -> Lexer.isLetter(next.charValue()) || Lexer.isDigit(next.charValue()));
                token = LexemeType.WORD;
            } else if (curr == ' ') {
                i.skip(next -> next.charValue() == ' ');
                token = LexemeType.SPACE;
            } else if (curr == '\r' || curr == '\n') {
                int[] cr = new int[]{curr == '\r' ? 1 : 0};
                int[] lf = new int[]{curr == '\n' ? 1 : 0};
                i.skip(next -> {
                    cr[0] = cr[0] + (next.charValue() == '\r' ? 1 : 0);
                    lf[0] = lf[0] + (next.charValue() == '\n' ? 1 : 0);
                    return next.charValue() == '\r' || next.charValue() == '\n';
                });
                token = cr[0] + lf[0] == 1 || cr[0] == 1 && lf[0] == 1 ? LexemeType.EOL : LexemeType.EOP;
            } else if (Character.isWhitespace(curr)) {
                i.skip(Character::isWhitespace);
                token = LexemeType.SPACE;
            } else if (Lexer.isDigit(curr) || Lexer.isNumeric(curr) && Lexer.isDigit(i.peek())) {
                i.skip(next -> Lexer.isDigit(next.charValue()) || Lexer.isNumeric(next.charValue()) && Lexer.isDigit(i.peek()));
                token = LexemeType.NUMBER;
            } else if (curr == '.') {
                i.skip(next -> next.charValue() == '.' || next.charValue() == ' ' && i.peek() == '.');
                token = i.index() - index == 0 ? LexemeType.PERIOD : LexemeType.ELLIPSIS;
            } else if (curr == '\"') {
                token = LexemeType.QUOTE_DOUBLE;
            } else if (curr == '\'') {
                token = LexemeType.QUOTE_SINGLE;
            } else if (curr == '-' && i.peek() != '-') {
                token = LexemeType.HYPHEN;
            } else if (Lexer.isDash(curr)) {
                i.skip(Lexer::isDash);
                token = LexemeType.DASH;
            } else if (curr == '(' || curr == '{' || curr == '[') {
                token = LexemeType.OPENING_GROUP;
            } else if (curr == ')' || curr == '}' || curr == ']') {
                token = LexemeType.CLOSING_GROUP;
            } else if (LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING);
            } else if (LexemeGlyph.LEX_DOUBLE_QUOTE_CLOSING.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_CLOSING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_CLOSING);
            } else if (LexemeGlyph.LEX_SINGLE_QUOTE_OPENING.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_OPENING.with(LexemeGlyph.LEX_SINGLE_QUOTE_OPENING);
            } else if (LexemeGlyph.LEX_SINGLE_QUOTE_CLOSING.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_CLOSING.with(LexemeGlyph.LEX_SINGLE_QUOTE_CLOSING);
            } else if (curr == '\\') {
                i.next();
                char next2 = i.current();
                if (next2 == '\'') {
                    token = LexemeType.ESC_SINGLE;
                } else if (next2 == '\"') {
                    token = LexemeType.ESC_DOUBLE;
                } else {
                    i.prev();
                }
            } else if (curr == '=') {
                token = LexemeType.EQUALS;
            } else if (curr == ',' && i.peek() == ',') {
                i.skip(next -> next.charValue() == ',');
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING_LOW);
            } else if (LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING_LOW.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_QUOTE_OPENING_LOW);
            } else if (LexemeGlyph.LEX_SINGLE_CHEVRON_LEFT.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_OPENING.with(LexemeGlyph.LEX_SINGLE_CHEVRON_LEFT);
            } else if (LexemeGlyph.LEX_DOUBLE_CHEVRON_LEFT.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_OPENING.with(LexemeGlyph.LEX_DOUBLE_CHEVRON_LEFT);
            } else if (LexemeGlyph.LEX_SINGLE_CHEVRON_RIGHT.equals(curr)) {
                token = LexemeType.QUOTE_SINGLE_CLOSING.with(LexemeGlyph.LEX_SINGLE_CHEVRON_RIGHT);
            } else if (LexemeGlyph.LEX_DOUBLE_CHEVRON_RIGHT.equals(curr)) {
                token = LexemeType.QUOTE_DOUBLE_CLOSING.with(LexemeGlyph.LEX_DOUBLE_CHEVRON_RIGHT);
            } else if (curr == '\uffff') continue;
            assert (index >= 0);
            assert (curr != '\uffff');
            consumer.accept(new Lexeme(token, index, i.index() + 1));
            i.next();
        }
        consumer.accept(new Lexeme(LexemeType.EOL, i.index(), i.index()));
        consumer.accept(new Lexeme(LexemeType.EOP, i.index(), i.index()));
        consumer.accept(Lexeme.EOT);
    }

    private static boolean isLetter(char curr) {
        return Character.isLetter(curr) || curr == '_' || curr == '*';
    }

    private static boolean isDigit(char curr) {
        return Character.isDigit(curr) || "\u00bc\u00bd\u00be\u2150\u2151\u2152\u2153\u2154\u2155\u2156\u2157\u2158\u2159\u215a\u215b\u215c\u215d\u215e".indexOf(curr) > -1;
    }

    private static boolean isDash(char curr) {
        return curr == '-' || curr == '\u2013' || curr == '\u2014' || curr == '\u2015';
    }

    private static boolean isNumeric(char curr) {
        return curr == '.' || curr == ',' || curr == '-' || curr == '+' || curr == '^' || curr == '\u215f' || curr == '\u2044';
    }
}

