/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.util;

import java.util.function.Function;

public final class FastCharacterIterator {
    private final String mS;
    private final int mLen;
    private int mPos;

    public FastCharacterIterator(String s) {
        this.mS = s;
        this.mLen = s.length();
    }

    public int index() {
        return this.mPos;
    }

    public char current() {
        int pos = this.mPos;
        return pos < this.mLen ? this.mS.charAt(pos) : (char)'\uffff';
    }

    public void next() {
        ++this.mPos;
    }

    public void prev() {
        --this.mPos;
    }

    public char peek() {
        int pos = this.mPos;
        return pos + 1 < this.mLen ? this.mS.charAt(pos + 1) : (char)'\uffff';
    }

    public boolean hasNext() {
        return this.mPos < this.mLen;
    }

    public void skip(Function<Character, Boolean> f) {
        assert (f != null);
        do {
            this.next();
        } while (f.apply(Character.valueOf(this.current())).booleanValue());
        this.prev();
    }

    public String substring(int began, int ended) {
        assert (began >= 0);
        assert (began <= ended);
        assert (ended < this.mLen);
        return this.mS.substring(began, ended);
    }
}

