/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;

public class SpaceAtom
extends Atom {
    private static final UnitConversion[] unitConversions = new UnitConversion[]{env -> {
        TeXEnvironment teXEnvironment;
        return env.getTeXFont().getXHeight(env.getStyle(), teXEnvironment.getLastFontId());
    }, env -> {
        TeXEnvironment teXEnvironment;
        return env.getTeXFont().getXHeight(env.getStyle(), teXEnvironment.getLastFontId());
    }, env -> {
        TeXEnvironment teXEnvironment;
        return 1.0f / teXEnvironment.getFontPointSize();
    }, env -> {
        TeXEnvironment teXEnvironment;
        return TeXFormula.PIXELS_PER_POINT / teXEnvironment.getFontPointSize();
    }, env -> {
        TeXEnvironment teXEnvironment;
        return 12.0f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getFontPointSize();
    }, env -> {
        void var1_1;
        TeXEnvironment teXEnvironment;
        TeXFont tf = env.getTeXFont();
        return tf.getQuad(teXEnvironment.getStyle(), var1_1.getMuFontId()) / 18.0f;
    }};
    private boolean blankSpace;
    private float width;
    private float height;
    private float depth;
    private int wUnit;
    private int hUnit;
    private int dUnit;

    public SpaceAtom() {
        this.blankSpace = true;
    }

    /*
     * WARNING - void declaration
     */
    public SpaceAtom(int unit, float width, float height, float depth) throws InvalidUnitException {
        void var3_3;
        void var2_2;
        void var1_1;
        SpaceAtom.checkUnit(unit);
        this.wUnit = unit;
        this.hUnit = unit;
        this.dUnit = var1_1;
        this.width = var2_2;
        this.height = var3_3;
        this.depth = depth;
    }

    public static void checkUnit(int unit) throws InvalidUnitException {
        int n;
        if (unit < 0 || n >= unitConversions.length) {
            throw new InvalidUnitException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public SpaceAtom(int widthUnit, float width, int heightUnit, float height, int depthUnit, float depth) throws InvalidUnitException {
        void var2_2;
        void var3_3;
        void var1_1;
        SpaceAtom.checkUnit(widthUnit);
        SpaceAtom.checkUnit(heightUnit);
        SpaceAtom.checkUnit(depthUnit);
        this.wUnit = var1_1;
        this.hUnit = var3_3;
        this.dUnit = depthUnit;
        this.width = var2_2;
        this.height = height;
        this.depth = depth;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Box createBox(TeXEnvironment env) {
        void var1_1;
        if (this.blankSpace) {
            return new StrutBox(env.getSpace());
        }
        return new StrutBox(this.width * SpaceAtom.getFactor(this.wUnit, env), this.height * SpaceAtom.getFactor(this.hUnit, env), this.depth * SpaceAtom.getFactor(this.dUnit, (TeXEnvironment)var1_1), 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static float getFactor(int unit, TeXEnvironment env) {
        void var1_1;
        int n;
        return unitConversions[n].getPixelConversion((TeXEnvironment)var1_1);
    }

    private static interface UnitConversion {
        public float getPixelConversion(TeXEnvironment var1);
    }
}

