/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.TeXConstants;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class TeXFormulaParser {
    private static final Map<String, Class<?>> classMappings = new HashMap();
    private final Map<String, ArgumentValueParser> argValueParsers = new HashMap<String, ArgumentValueParser>();
    private final Map<String, ActionParser> actionParsers = new HashMap<String, ActionParser>();
    private final Map<String, TeXFormula> tempFormulas = new HashMap<String, TeXFormula>();
    private TeXFormula result = new TeXFormula();
    private final String formulaName;
    private final Element formula;

    /*
     * WARNING - void declaration
     */
    public TeXFormulaParser(String name, Element formula) {
        void var2_2;
        void var1_1;
        this.formulaName = var1_1;
        this.formula = var2_2;
        this.actionParsers.put("CreateTeXFormula", new CreateTeXFormulaParser(this));
        this.actionParsers.put("MethodInvocation", new MethodInvocationParser(this));
        this.actionParsers.put("Return", new ReturnParser(this));
        this.argValueParsers.put("TeXConstants", new TeXConstantsValueParser());
        this.argValueParsers.put("TeXFormula", new TeXFormulaValueParser(this));
        this.argValueParsers.put("String", new StringValueParser());
        this.argValueParsers.put("float", new FloatValueParser());
        this.argValueParsers.put("int", new IntValueParser());
        this.argValueParsers.put("boolean", new BooleanValueParser());
        this.argValueParsers.put("char", new CharValueParser());
        this.argValueParsers.put("ColorConstant", new ColorConstantValueParser());
    }

    /*
     * WARNING - void declaration
     */
    public TeXFormula parse() throws ResourceParseException {
        for (Element element : this.formula.getChildren()) {
            void var3_3;
            Element el = element;
            ActionParser p = this.actionParsers.get(el.getName());
            if (p == null) continue;
            var3_3.parse(element);
        }
        return this.result;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] getArgumentValues(List<Element> args) {
        void var2_2;
        Iterator iterator;
        Object[] res = new Object[args.size()];
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Element arg = (Element)e;
            String type = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", arg);
            String value = arg.getAttributeValue("value");
            res[i] = this.argValueParsers.get(type).parseValue(value, type);
            ++i;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Class[] getArgumentClasses(List<Element> args) throws ResourceParseException {
        void var1_1;
        Iterator<Element> iterator;
        Class[] res = new Class[args.size()];
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Element arg = (Element)e;
            String type = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", arg);
            Class<?> cl = classMappings.get(type);
            if (cl == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "type", "has an invalid class name value!");
            }
            res[i] = (Class)e;
            ++i;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkNullValue(String value, String type) throws ResourceParseException {
        if (value == null) {
            void var1_1;
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "is required for an argument of type '" + (String)var1_1 + "'");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        void var2_2;
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            String string;
            void var1_1;
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", var1_1.getName(), string, null);
        }
        return var2_2;
    }

    static {
        classMappings.put("TeXConstants", Integer.TYPE);
        classMappings.put("TeXFormula", TeXFormula.class);
        classMappings.put("String", String.class);
        classMappings.put("float", Float.TYPE);
        classMappings.put("int", Integer.TYPE);
        classMappings.put("boolean", Boolean.TYPE);
        classMappings.put("char", Character.TYPE);
        classMappings.put("ColorConstant", Color.class);
    }

    final class CreateTeXFormulaParser
    implements ActionParser {
        private /* synthetic */ TeXFormulaParser this$0;

        CreateTeXFormulaParser(TeXFormulaParser teXFormulaParser) {
            this.this$0 = teXFormulaParser;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(Element el) throws ResourceParseException {
            String name = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            List<Element> args = el.getChildren("Argument");
            Class[] argClasses = TeXFormulaParser.getArgumentClasses(args);
            Object[] argValues = this.this$0.getArgumentValues(args);
            try {
                void var3_3;
                TeXFormula f = (TeXFormula)TeXFormula.class.getConstructor((Class<?>)var3_3).newInstance(argValues);
                this.this$0.tempFormulas.put(name, f);
                return;
            }
            catch (Exception exception) {
                void var1_1;
                void var2_2;
                Exception e = exception;
                exception.printStackTrace();
                throw new XMLResourceParseException("Error creating the temporary TeXFormula '" + (String)var2_2 + "' while constructing the predefined TeXFormula '" + this.this$0.formulaName + "'", (Throwable)var1_1);
            }
        }
    }

    final class MethodInvocationParser
    implements ActionParser {
        private /* synthetic */ TeXFormulaParser this$0;

        MethodInvocationParser(TeXFormulaParser teXFormulaParser) {
            this.this$0 = teXFormulaParser;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(Element el) throws ResourceParseException {
            String methodName = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            String objectName = TeXFormulaParser.getAttrValueAndCheckIfNotNull("formula", el);
            TeXFormula object = this.this$0.tempFormulas.get(objectName);
            if (object == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "formula", "has an unknown temporary TeXFormula name as value : '" + objectName + "'");
            }
            List<Element> args = el.getChildren("Argument");
            Class[] argClasses = TeXFormulaParser.getArgumentClasses(args);
            Object[] argValues = this.this$0.getArgumentValues(args);
            try {
                TeXFormula.class.getMethod(methodName, argClasses).invoke((Object)object, argValues);
                return;
            }
            catch (Exception e) {
                void var1_2;
                void var3_4;
                void var2_3;
                throw new XMLResourceParseException("Error invoking the method '" + (String)var2_3 + "' on the temporary TeXFormula '" + (String)var3_4 + "' while constructing the predefined TeXFormula '" + this.this$0.formulaName + "'", (Throwable)var1_2);
            }
        }
    }

    final class ReturnParser
    implements ActionParser {
        private /* synthetic */ TeXFormulaParser this$0;

        ReturnParser(TeXFormulaParser teXFormulaParser) {
            this.this$0 = teXFormulaParser;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(Element el) throws ResourceParseException {
            void var2_2;
            String name = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            TeXFormula res = this.this$0.tempFormulas.get(name);
            if (res == null) {
                void var1_1;
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Return", "name", "contains an unknown temporary TeXFormula variable name '" + (String)var1_1 + "' for the predefined TeXFormula '" + this.this$0.formulaName + "'");
            }
            this.this$0.result = var2_2;
        }
    }

    static final class TeXConstantsValueParser
    implements ArgumentValueParser {
        TeXConstantsValueParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return TeXConstants.class.getDeclaredField(value).getInt(null);
            }
            catch (Exception e) {
                void var2_3;
                void var1_1;
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an unknown constant name as value : '" + (String)var1_1 + "'", (Throwable)var2_3);
            }
        }
    }

    final class TeXFormulaValueParser
    implements ArgumentValueParser {
        private /* synthetic */ TeXFormulaParser this$0;

        TeXFormulaValueParser(TeXFormulaParser teXFormulaParser) {
            this.this$0 = teXFormulaParser;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            void var2_2;
            if (value == null) {
                return null;
            }
            TeXFormula formula = this.this$0.tempFormulas.get(value);
            if (formula == null) {
                void var1_1;
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an unknown temporary TeXFormula name as value : '" + (String)var1_1 + "'");
            }
            return var2_2;
        }
    }

    static final class StringValueParser
    implements ArgumentValueParser {
        StringValueParser() {
        }

        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            return value;
        }
    }

    static final class FloatValueParser
    implements ArgumentValueParser {
        FloatValueParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                void var3_3;
                void var1_1;
                void var2_2;
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an invalid '" + (String)var2_2 + "'-value : '" + (String)var1_1 + "'", (Throwable)var3_3);
            }
        }
    }

    static final class IntValueParser
    implements ArgumentValueParser {
        IntValueParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                int n = Integer.parseInt(value);
                return Float.valueOf(n);
            }
            catch (NumberFormatException e) {
                void var3_4;
                void var1_1;
                void var2_2;
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an invalid '" + (String)var2_2 + "'-value : '" + (String)var1_1 + "'", (Throwable)var3_4);
            }
        }
    }

    static final class BooleanValueParser
    implements ArgumentValueParser {
        BooleanValueParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            void var1_1;
            void var2_2;
            TeXFormulaParser.checkNullValue(value, type);
            if ("true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an invalid '" + (String)var2_2 + "'-value : '" + (String)var1_1 + "'");
        }
    }

    static final class CharValueParser
    implements ArgumentValueParser {
        CharValueParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            void var2_2;
            TeXFormulaParser.checkNullValue(value, (String)var2_2);
            if (value.length() == 1) {
                void var1_1;
                return Character.valueOf(var1_1.charAt(0));
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "must have a value that consists of exactly 1 character!");
        }
    }

    static final class ColorConstantValueParser
    implements ArgumentValueParser {
        ColorConstantValueParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return Color.class.getDeclaredField(value).get(null);
            }
            catch (Exception e) {
                void var2_3;
                void var1_1;
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "value", "has an unknown color constant name as value : '" + (String)var1_1 + "'", (Throwable)var2_3);
            }
        }
    }

    static interface ActionParser {
        public void parse(Element var1) throws ResourceParseException;
    }

    static interface ArgumentValueParser {
        public Object parseValue(String var1, String var2) throws ResourceParseException;
    }
}

