/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.Glue;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Element;

public class GlueSettingsParser {
    private static final Map<String, Integer> typeMappings = new HashMap<String, Integer>();
    private static final Map<String, Integer> styleMappings = new HashMap<String, Integer>();
    private final Map<String, Integer> glueTypeMappings = new HashMap<String, Integer>();
    private Glue[] glueTypes;
    private final Element root = new XMLResourceReader("GlueSettings.xml").read();

    public GlueSettingsParser() throws ResourceParseException {
        this.parseGlueTypes();
    }

    /*
     * WARNING - void declaration
     */
    private void parseGlueTypes() throws ResourceParseException {
        void var1_1;
        ArrayList<Glue> glueTypesList = new ArrayList<Glue>();
        Element types = this.root.getChild("GlueTypes");
        int defaultIndex = -1;
        int index = 0;
        if (types != null) {
            for (Object e : types.getChildren("GlueType")) {
                Element element = (Element)e;
                String name = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", element);
                Glue e2 = GlueSettingsParser.createGlue(element, name);
                if (name.equalsIgnoreCase("default")) {
                    defaultIndex = index;
                }
                glueTypesList.add(e2);
                ++index;
            }
        }
        if (defaultIndex < 0) {
            defaultIndex = index;
            glueTypesList.add(new Glue(0.0f, 0.0f, 0.0f, "default"));
        }
        this.glueTypes = var1_1.toArray(new Glue[0]);
        if (defaultIndex > 0) {
            Glue tmp = this.glueTypes[defaultIndex];
            this.glueTypes[var3_4] = this.glueTypes[0];
            this.glueTypes[0] = tmp;
        }
        for (int i = 0; i < this.glueTypes.length; ++i) {
            this.glueTypeMappings.put(this.glueTypes[i].getName(), i);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Glue createGlue(Element type, String name) throws ResourceParseException {
        void var1_1;
        void var3_3;
        String[] names = new String[]{"space", "stretch", "shrink"};
        float[] values = new float[3];
        for (int i = 0; i < 3; ++i) {
            double val = 0.0;
            String attrVal = null;
            try {
                attrVal = type.getAttributeValue(names[i]);
                if (attrVal != null) {
                    val = Double.parseDouble(attrVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLResourceParseException("GlueSettings.xml", "GlueType", names[i], "has an invalid real value '" + attrVal + "'");
            }
            values[i] = (float)val;
        }
        return new Glue(values[0], values[1], (float)var3_3[2], (String)var1_1);
    }

    public Glue[] getGlueTypes() {
        return this.glueTypes;
    }

    /*
     * WARNING - void declaration
     */
    public int[][][] createGlueTable() throws ResourceParseException {
        void var1_2;
        int size = typeMappings.size();
        int[][][] table = new int[size][size][styleMappings.size()];
        Element glueTable = this.root.getChild("GlueTable");
        if (glueTable != null) {
            Iterator<Element> iterator;
            iterator = ((Element)((Object)iterator)).getChildren("Glue").iterator();
            while (iterator.hasNext()) {
                Element element;
                Element element2 = element = iterator.next();
                String left = GlueSettingsParser.getAttrValueAndCheckIfNotNull("lefttype", element2);
                String right = GlueSettingsParser.getAttrValueAndCheckIfNotNull("righttype", element2);
                String type = GlueSettingsParser.getAttrValueAndCheckIfNotNull("gluetype", element2);
                Iterator<Element> object = element2.getChildren("Style").iterator();
                while (object.hasNext()) {
                    Element element3;
                    Element style = element3 = object.next();
                    String styleName = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", style);
                    Integer l = typeMappings.get(left);
                    Integer r = typeMappings.get(right);
                    Integer st = styleMappings.get(styleName);
                    Integer val = this.glueTypeMappings.get(type);
                    GlueSettingsParser.checkMapping(l, "Glue", "lefttype", left);
                    GlueSettingsParser.checkMapping(r, "Glue", "righttype", right);
                    GlueSettingsParser.checkMapping(val, "Glue", "gluetype", type);
                    GlueSettingsParser.checkMapping(st, "Style", "name", styleName);
                    table[l.intValue()][r.intValue()][st.intValue()] = val;
                }
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkMapping(Object val, String elementName, String attrName, String attrValue) throws ResourceParseException {
        if (val == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new XMLResourceParseException("GlueSettings.xml", (String)var1_1, (String)var2_2, "has an unknown value '" + (String)var3_3 + "'");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        void var2_2;
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            String string;
            void var1_1;
            throw new XMLResourceParseException("GlueSettings.xml", var1_1.getName(), string, null);
        }
        return var2_2;
    }

    static {
        styleMappings.put("display", 0);
        styleMappings.put("text", 1);
        styleMappings.put("script", 2);
        styleMappings.put("script_script", 3);
        typeMappings.put("ord", 0);
        typeMappings.put("op", 1);
        typeMappings.put("bin", 2);
        typeMappings.put("rel", 3);
        typeMappings.put("open", 4);
        typeMappings.put("close", 5);
        typeMappings.put("punct", 6);
        typeMappings.put("inner", 7);
    }
}

