/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom2.IllegalNameException;
import org.jdom2.Verifier;

public final class Namespace
implements Serializable {
    private static final ConcurrentMap<String, ConcurrentMap<String, Namespace>> namespacemap;
    public static final Namespace NO_NAMESPACE;
    public static final Namespace XML_NAMESPACE;
    private static final Namespace XMLNS_NAMESPACE;
    private final transient String prefix;
    private final transient String uri;

    /*
     * WARNING - void declaration
     */
    public static Namespace getNamespace(String prefix, String uri) {
        void var3_3;
        void var2_2;
        void var1_1;
        String pfx;
        Object ns;
        if (uri == null) {
            if (prefix == null || "".equals(prefix)) {
                return NO_NAMESPACE;
            }
            throw new IllegalNameException("", "namespace", "Namespace URIs must be non-null and non-empty Strings");
        }
        ConcurrentMap urimap = (ConcurrentHashMap)namespacemap.get(uri);
        if (urimap == null) {
            String reason = Verifier.checkNamespaceURI(uri);
            if (reason != null) {
                throw new IllegalNameException(uri, "Namespace URI", reason);
            }
            urimap = new ConcurrentHashMap();
            ConcurrentMap xmap = namespacemap.putIfAbsent(uri, urimap);
            if (xmap != null) {
                urimap = xmap;
            }
        }
        if ((ns = (Namespace)urimap.get(prefix == null ? "" : prefix)) != null) {
            return ns;
        }
        if ("".equals(uri)) {
            throw new IllegalNameException("", "namespace", "Namespace URIs must be non-null and non-empty Strings");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            throw new IllegalNameException(uri, "Namespace URI", "The http://www.w3.org/XML/1998/namespace must be bound to only the 'xml' prefix.");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            throw new IllegalNameException(uri, "Namespace URI", "The http://www.w3.org/2000/xmlns/ must be bound to only the 'xmlns' prefix.");
        }
        String string = pfx = prefix == null ? "" : prefix;
        if ("xml".equals(pfx)) {
            throw new IllegalNameException(uri, "Namespace prefix", "The prefix xml (any case) can only be bound to only the 'http://www.w3.org/XML/1998/namespace' uri.");
        }
        if ("xmlns".equals(pfx)) {
            throw new IllegalNameException(uri, "Namespace prefix", "The prefix xmlns (any case) can only be bound to only the 'http://www.w3.org/2000/xmlns/' uri.");
        }
        Namespace reason = Verifier.checkNamespacePrefix(pfx);
        if (reason != null) {
            throw new IllegalNameException(pfx, "Namespace prefix", (String)((Object)reason));
        }
        ns = new Namespace(pfx, (String)var1_1);
        Namespace prev = var2_2.putIfAbsent(pfx, ns);
        if (prev != null) {
            Namespace namespace;
            ns = namespace;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Namespace(String prefix, String uri) {
        void var2_2;
        void var1_1;
        this.prefix = var1_1;
        this.uri = var2_2;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final String getURI() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (ob instanceof Namespace) {
            void var1_1;
            return this.uri.equals(((Namespace)var1_1).uri);
        }
        return false;
    }

    public final String toString() {
        return "[Namespace: prefix \"" + this.prefix + "\" is mapped to URI \"" + this.uri + "\"]";
    }

    public final int hashCode() {
        return this.uri.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        namespacemap = new ConcurrentHashMap<String, ConcurrentMap<String, Namespace>>(512, 0.75f, 64);
        NO_NAMESPACE = new Namespace("", "");
        XML_NAMESPACE = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
        XMLNS_NAMESPACE = new Namespace("xmlns", "http://www.w3.org/2000/xmlns/");
        ConcurrentHashMap<String, Namespace> nmap = new ConcurrentHashMap<String, Namespace>();
        Namespace namespace = NO_NAMESPACE;
        nmap.put(namespace.prefix, NO_NAMESPACE);
        namespace = NO_NAMESPACE;
        namespacemap.put(namespace.uri, nmap);
        ConcurrentHashMap<String, Namespace> xmap = new ConcurrentHashMap<String, Namespace>();
        namespace = XML_NAMESPACE;
        xmap.put(namespace.prefix, XML_NAMESPACE);
        namespace = XML_NAMESPACE;
        namespacemap.put(namespace.uri, xmap);
        ConcurrentHashMap<String, Namespace> xnsmap = new ConcurrentHashMap<String, Namespace>();
        namespace = XMLNS_NAMESPACE;
        xnsmap.put(namespace.prefix, XMLNS_NAMESPACE);
        namespace = XMLNS_NAMESPACE;
        namespacemap.put(namespace.uri, (ConcurrentMap<String, Namespace>)var0);
    }
}

