/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.input;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.input.sax.BuilderErrorHandler;
import org.jdom2.input.sax.DefaultSAXHandlerFactory;
import org.jdom2.input.sax.SAXBuilderEngine;
import org.jdom2.input.sax.SAXEngine;
import org.jdom2.input.sax.SAXHandler;
import org.jdom2.input.sax.SAXHandlerFactory;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public final class SAXBuilder
implements SAXEngine {
    private static final SAXHandlerFactory DEFAULTSAXHANDLERFAC = new DefaultSAXHandlerFactory();
    private static final JDOMFactory DEFAULTJDOMFAC = new JDOMFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Attribute attribute(String name, String value, AttributeType type, Namespace namespace) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new Attribute((String)var1_1, (String)var2_2, (AttributeType)var3_3, namespace);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public CDATA cdata(String str) {
            void var1_1;
            return this.cdata$53ca8ce3((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public CDATA cdata$53ca8ce3(String text) {
            void var1_1;
            return new CDATA((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Text text(String str) {
            void var1_1;
            return this.text$57235f87((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Text text$57235f87(String text) {
            void var1_1;
            return new Text((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Comment comment(String text) {
            void var1_1;
            return this.comment$457279ef((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Comment comment$457279ef(String text) {
            void var1_1;
            return new Comment((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DocType docType(String elementName, String publicID, String systemID) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.docType$10015d2e((String)var1_1, (String)var2_2, (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DocType docType$10015d2e(String elementName, String publicID, String systemID) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new DocType((String)var1_1, (String)var2_2, (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Document document(Element rootElement) {
            void var1_1;
            return new Document((Element)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Element element(String name, Namespace namespace) {
            void var2_2;
            void var1_1;
            return this.element$33a6c944((String)var1_1, (Namespace)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Element element$33a6c944(String name, Namespace namespace) {
            void var2_2;
            void var1_1;
            return new Element((String)var1_1, (Namespace)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ProcessingInstruction processingInstruction(String target, String data) {
            void var2_2;
            void var1_1;
            return this.processingInstruction$1fdad441((String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ProcessingInstruction processingInstruction$1fdad441(String target, String data) {
            void var2_2;
            void var1_1;
            return new ProcessingInstruction((String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public EntityRef entityRef(String name) {
            void var1_1;
            return this.entityRef$40b91060((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public EntityRef entityRef$40b91060(String name) {
            void var1_1;
            return new EntityRef((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public EntityRef entityRef(String name, String publicID, String systemID) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.entityRef$7fabaf34((String)var1_1, (String)var2_2, (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public EntityRef entityRef$7fabaf34(String name, String publicID, String systemID) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new EntityRef((String)var1_1, (String)var2_2, (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addContent(Parent parent, Content child) {
            void var2_2;
            Element element;
            if (parent instanceof Document) {
                parent = (Document)parent;
                ((Document)parent).content.add(child);
                return;
            }
            element = element;
            element.content.add(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setAttribute(Element parent, Attribute a) {
            void var2_2;
            Element element = parent;
            element.getAttributeList().add((Attribute)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setRoot(Document doc, Element root) {
            void var2_2;
            doc.setRootElement((Element)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static <E> E[] copyOf(E[] source, int len) {
            void var2_2;
            E[] EArray;
            int n;
            Object[] dest = (Object[])Array.newInstance(source.getClass().getComponentType(), len);
            System.arraycopy(source, 0, dest, 0, len < source.length ? n : EArray.length);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public static int[] copyOf(int[] source, int len) {
            void var2_2;
            int[] nArray;
            int n;
            int[] dest = new int[len];
            System.arraycopy(source, 0, dest, 0, len < source.length ? n : nArray.length);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public static String get(String property, String def) {
            try {
                return System.getProperty(property, def);
            }
            catch (SecurityException securityException) {
                void var1_1;
                return var1_1;
            }
        }
    };
    private XMLReaderJDOMFactory readerfac = null;
    private SAXHandlerFactory handlerfac = null;
    private JDOMFactory jdomfac = null;
    private final HashMap<String, Boolean> features = new HashMap(5);
    private final HashMap<String, Object> properties = new HashMap(5);
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private boolean reuseParser = true;
    private SAXEngine engine = null;

    public SAXBuilder() {
        this(null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private SAXBuilder(XMLReaderJDOMFactory xmlreaderfactory, SAXHandlerFactory handlerfactory, JDOMFactory jdomfactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean bl = true;
        SAXBuilder sAXBuilder = this;
        sAXBuilder.features.put("http://xml.org/sax/features/external-general-entities", Boolean.TRUE);
        sAXBuilder.engine = null;
        this.readerfac = xmlreaderfactory == null ? XMLReaders.NONVALIDATING : var1_1;
        this.handlerfac = handlerfactory == null ? DEFAULTSAXHANDLERFAC : var2_2;
        this.jdomfac = jdomfactory == null ? DEFAULTJDOMFAC : var3_3;
    }

    private boolean getExpandEntities() {
        return Boolean.TRUE.equals(this.features.get("http://xml.org/sax/features/external-general-entities"));
    }

    /*
     * WARNING - void declaration
     */
    private SAXEngine buildEngine() throws JDOMException {
        void var3_3;
        void var1_1;
        void var2_6;
        Object object;
        SAXHandler contentHandler = this.handlerfac.createSAXHandler(this.jdomfac);
        contentHandler.setExpandEntities(this.getExpandEntities());
        contentHandler.setIgnoringElementContentWhitespace(false);
        contentHandler.setIgnoringBoundaryWhitespace(false);
        SAXBuilder sAXBuilder = this;
        XMLReader xMLReader = sAXBuilder.readerfac.createXMLReader();
        if (sAXBuilder.saxXMLFilter != null) {
            object = sAXBuilder.saxXMLFilter;
            while (object.getParent() instanceof XMLFilter) {
                object = (XMLFilter)object.getParent();
            }
            object.setParent(xMLReader);
            xMLReader = sAXBuilder.saxXMLFilter;
        }
        XMLReader parser = xMLReader;
        object = contentHandler;
        xMLReader = parser;
        sAXBuilder = this;
        xMLReader.setContentHandler((ContentHandler)object);
        if (sAXBuilder.saxEntityResolver != null) {
            xMLReader.setEntityResolver(sAXBuilder.saxEntityResolver);
        }
        if (sAXBuilder.saxDTDHandler != null) {
            xMLReader.setDTDHandler(sAXBuilder.saxDTDHandler);
        } else {
            xMLReader.setDTDHandler((DTDHandler)object);
        }
        if (sAXBuilder.saxErrorHandler != null) {
            xMLReader.setErrorHandler(sAXBuilder.saxErrorHandler);
        } else {
            xMLReader.setErrorHandler(new BuilderErrorHandler());
        }
        boolean bl = false;
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
            bl = true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        if (!bl) {
            try {
                xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", object);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        }
        for (Map.Entry<String, Object> entry : sAXBuilder.properties.entrySet()) {
            SAXBuilder.internalSetProperty(xMLReader, entry.getKey(), entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : sAXBuilder.features.entrySet()) {
            SAXBuilder.internalSetFeature(xMLReader, entry.getKey(), (Boolean)entry.getValue(), entry.getKey());
        }
        if (!sAXBuilder.getExpandEntities()) {
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", object);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        }
        boolean valid = this.readerfac.isValidating();
        return new SAXBuilderEngine((XMLReader)var2_6, (SAXHandler)var1_1, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void internalSetFeature(XMLReader parser, String feature, boolean value, String displayName) throws JDOMException {
        try {
            void var2_2;
            parser.setFeature(feature, (boolean)var2_2);
            return;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(displayName + " feature " + feature + " not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            XMLReader xMLReader;
            void var1_1;
            void var3_3;
            throw new JDOMException((String)var3_3 + " feature " + (String)var1_1 + " not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void internalSetProperty(XMLReader parser, String property, Object value, String displayName) throws JDOMException {
        try {
            void var2_2;
            parser.setProperty(property, var2_2);
            return;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(displayName + " property " + property + " not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            XMLReader xMLReader;
            void var1_1;
            void var3_3;
            throw new JDOMException((String)var3_3 + " property " + (String)var1_1 + " not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    public final Document build(InputStream in) throws JDOMException, IOException {
        try {
            Document document;
            SAXBuilder sAXBuilder = this;
            document = (sAXBuilder.engine != null ? sAXBuilder.engine : (sAXBuilder.engine = sAXBuilder.buildEngine())).build((InputStream)((Object)document));
            return document;
        }
        finally {
            if (!this.reuseParser) {
                this.engine = null;
            }
        }
    }
}

