/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.GlueBox;
import com.whitemagicsoftware.tex.parsers.GlueSettingsParser;

public class Glue {
    private static final Glue[] glueTypes;
    private static final int[][][] glueTable;
    private final float space;
    private final float stretch;
    private final float shrink;
    private final String name;

    public Glue(float space, float stretch, float shrink, String name) {
        this.space = space;
        this.stretch = stretch;
        this.shrink = shrink;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Box get(int lType, int rType, TeXEnvironment env) {
        int l = lType > 7 ? 0 : lType;
        int r = rType > 7 ? 0 : rType;
        return glueTypes[glueTable[l][r][env.getStyle() / 2]].createBox(env);
    }

    private Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        float quad = tf.getQuad(env.getStyle(), tf.getMuFontId());
        return new GlueBox(this.space / 18.0f * quad);
    }

    static {
        GlueSettingsParser parser = new GlueSettingsParser();
        glueTypes = parser.getGlueTypes();
        glueTable = parser.createGlueTable();
    }
}

