/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.TeXFont;
import java.awt.Color;

public class TeXEnvironment {
    private Color background;
    private Color foreground;
    private int style;
    private final TeXFont tf;
    private int lastFontId = -1;

    public TeXEnvironment(TeXFont tf) {
        this(0, tf, null, null);
    }

    public TeXEnvironment(int style, TeXFont tf) {
        this(style, tf, null, null);
    }

    private TeXEnvironment(int style, TeXFont tf, Color bg, Color fg) {
        this.style = style == 0 || style == 2 || style == 4 || style == 6 ? style : 0;
        this.tf = tf;
        this.background = bg;
        this.foreground = fg;
    }

    public TeXEnvironment copy() {
        return new TeXEnvironment(this.style, this.tf, this.background, this.foreground);
    }

    public TeXEnvironment crampStyle() {
        TeXEnvironment s = this.copy();
        s.style = this.style % 2 == 1 ? this.style : this.style + 1;
        return s;
    }

    public TeXEnvironment denomStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 2) + 1 + 2 - 2 * (this.style / 6);
        return s;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getColor() {
        return this.foreground;
    }

    public float getFontPointSize() {
        return this.tf.pointSize();
    }

    public int getStyle() {
        return this.style;
    }

    public TeXFont getTeXFont() {
        return this.tf;
    }

    public TeXEnvironment numStyle() {
        TeXEnvironment s = this.copy();
        s.style = this.style + 2 - 2 * (this.style / 6);
        return s;
    }

    public void reset() {
        this.foreground = null;
        this.background = null;
    }

    public TeXEnvironment rootStyle() {
        TeXEnvironment s = this.copy();
        s.style = 6;
        return s;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void setColor(Color c) {
        this.foreground = c;
    }

    public TeXEnvironment subStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 4) + 4 + 1;
        return s;
    }

    public TeXEnvironment supStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 4) + 4 + this.style % 2;
        return s;
    }

    public float getSpace() {
        return this.tf.getSpace(this.style);
    }

    public void setLastFontId(int id) {
        this.lastFontId = id;
    }

    public int getLastFontId() {
        return this.lastFontId == -1 ? this.tf.getMuFontId() : this.lastFontId;
    }
}

