/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.boxes.Box;
import java.awt.Insets;

public class TeXLayout {
    private static final float ROUND = 0.99f;
    private static final float TWEAK_WIDTH = 0.18f;
    private static final float TWEAK_HEIGHT = 0.18f;
    private final Box mBox;
    private final float mSize;
    private final Insets mInsets;

    public TeXLayout(Box box, float size) {
        this.mBox = box;
        this.mSize = size;
        this.mInsets = new Insets(0, 0, 0, 0);
    }

    public void setInsets(Insets insets) {
        float size = this.getSize();
        this.mInsets.top = (int)((float)insets.top + 0.18f * size);
        this.mInsets.bottom = (int)((float)insets.bottom + 0.18f * size);
        this.mInsets.left = (int)((float)insets.left + 0.18f * size);
        this.mInsets.right = (int)((float)insets.right + 0.18f * size);
    }

    public float getX() {
        return (float)this.mInsets.left / this.getSize();
    }

    public float getY() {
        return (float)this.mInsets.top / this.getSize() + this.getBox().getHeight();
    }

    public int getWidth() {
        Box box = this.getBox();
        float size = this.getSize();
        return (int)(box.getWidth() * size + 0.99f + (float)this.mInsets.left + (float)this.mInsets.right);
    }

    public int getHeight() {
        Box box = this.getBox();
        float size = this.getSize();
        return (int)(box.getHeight() * size + 0.99f + (float)this.mInsets.top) + (int)(box.getDepth() * size + 0.99f + (float)this.mInsets.bottom);
    }

    private Box getBox() {
        return this.mBox;
    }

    public float getSize() {
        return this.mSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mBox=" + String.valueOf(this.mBox) + ", mSize=" + this.mSize + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "}";
    }
}

