/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.Dummy;
import com.whitemagicsoftware.tex.Row;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.RowAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import java.awt.Color;

public class ColorAtom
extends Atom
implements Row {
    private final Color background;
    private final Color color;
    private final RowAtom elements;

    public ColorAtom(Atom atom, Color bg, Color c) {
        this.elements = new RowAtom(atom);
        this.background = bg;
        this.color = c;
    }

    public ColorAtom(Color bg, Color c, ColorAtom old) {
        this.elements = new RowAtom(old.elements);
        this.background = bg == null ? old.background : bg;
        this.color = c == null ? old.color : c;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        TeXEnvironment copy = env.copy();
        if (this.background != null) {
            copy.setBackground(this.background);
        }
        if (this.color != null) {
            copy.setColor(this.color);
        }
        return this.elements.createBox(copy);
    }

    @Override
    public int getLeftType() {
        return this.elements.getLeftType();
    }

    @Override
    public int getRightType() {
        return this.elements.getRightType();
    }

    @Override
    public void setPreviousAtom(Dummy prev) {
        this.elements.setPreviousAtom(prev);
    }
}

