/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.boxes;

import com.whitemagicsoftware.tex.Char;
import com.whitemagicsoftware.tex.FontInfo;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.boxes.Box;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public final class CharBox
extends Box {
    private final Char c;

    public CharBox(Char c) {
        this.width = c.getWidth();
        this.height = c.getHeight();
        this.depth = c.getDepth();
        this.c = c;
    }

    @Override
    public void draw(Graphics2D g, float x, float y) {
        AffineTransform at = g.getTransform();
        g.translate(x, y);
        float size = this.c.getSize();
        if (Math.abs(size - TeXFormula.FONT_SCALE_FACTOR) > 1.0E-7f) {
            g.scale(size / TeXFormula.FONT_SCALE_FACTOR, size / TeXFormula.FONT_SCALE_FACTOR);
        }
        g.setFont(FontInfo.getFont(this.c.getFontId()));
        g.drawChars(new char[]{this.c.getChar()}, 0, 1, 0, 0);
        g.setTransform(at);
    }

    @Override
    public int getLastFontId() {
        return this.c.getFontId();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{c=" + String.valueOf(this.c) + "}";
    }
}

