/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.resources;

import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import java.io.InputStream;
import java.util.function.Function;

public class ResourceReader<T> {
    private final String mPath;

    public ResourceReader(String path) {
        this.mPath = "/" + path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read(Function<InputStream, T> f) throws XMLResourceParseException {
        String filename = this.mPath;
        try (InputStream stream = this.getClass().getResourceAsStream(filename);){
            InputStream t = f.apply(stream);
            return (T)t;
        }
        catch (Exception e) {
            throw new XMLResourceParseException(filename, e);
        }
    }
}

