/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.IllegalDataException;
import org.jdom2.Parent;
import org.jdom2.Verifier;

public class Text
extends Content {
    protected String value;

    protected Text(Content.CType ctype) {
        super(ctype);
    }

    protected Text() {
        this(Content.CType.Text);
    }

    public Text(String str) {
        this(Content.CType.Text);
        this.setText(str);
    }

    public String getText() {
        return this.value;
    }

    public Text setText(String str) {
        if (str == null) {
            this.value = "";
            return this;
        }
        String reason = Verifier.checkCharacterData(str);
        if (reason != null) {
            throw new IllegalDataException(str, "character content", reason);
        }
        this.value = str;
        return this;
    }

    public String toString() {
        return new StringBuilder(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    public Text clone() {
        Text text = (Text)super.clone();
        text.value = this.value;
        return text;
    }

    protected Text setParent(Parent parent) {
        return (Text)super.setParent(parent);
    }

    public Element getParent() {
        return (Element)super.getParent();
    }
}

