/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.output;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import org.jdom2.output.EscapeStrategy;
import org.jdom2.output.LineSeparator;

public class Format
implements Cloneable {
    private static final EscapeStrategy UTFEscapeStrategy = new EscapeStrategyUTF();
    private static final EscapeStrategy Bits8EscapeStrategy = new EscapeStrategy8Bits();
    private static final EscapeStrategy Bits7EscapeStrategy = new EscapeStrategy7Bits();
    private static final EscapeStrategy DefaultEscapeStrategy = new EscapeStrategy(){};
    private static final String STANDARD_LINE_SEPARATOR = LineSeparator.DEFAULT.value();
    String indent = null;
    String lineSeparator = STANDARD_LINE_SEPARATOR;
    String encoding = "UTF-8";
    boolean omitDeclaration = false;
    boolean omitEncoding = false;
    boolean specifiedAttributesOnly = false;
    boolean expandEmptyElements = false;
    boolean ignoreTrAXEscapingPIs = false;
    TextMode mode = TextMode.PRESERVE;
    EscapeStrategy escapeStrategy = DefaultEscapeStrategy;

    public static Format getRawFormat() {
        return new Format();
    }

    private static final EscapeStrategy chooseStrategy(String encoding) {
        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16".equalsIgnoreCase(encoding)) {
            return UTFEscapeStrategy;
        }
        if (encoding.toUpperCase(Locale.ENGLISH).startsWith("ISO-8859-") || "Latin1".equalsIgnoreCase(encoding)) {
            return Bits8EscapeStrategy;
        }
        if ("US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding)) {
            return Bits7EscapeStrategy;
        }
        try {
            CharsetEncoder cse = Charset.forName(encoding).newEncoder();
            return new DefaultCharsetEscapeStrategy(cse);
        }
        catch (Exception exception) {
            return DefaultEscapeStrategy;
        }
    }

    private Format() {
        this.setEncoding("UTF-8");
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public boolean getOmitEncoding() {
        return this.omitEncoding;
    }

    public boolean getOmitDeclaration() {
        return this.omitDeclaration;
    }

    public boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public boolean getIgnoreTrAXEscapingPIs() {
        return this.ignoreTrAXEscapingPIs;
    }

    public TextMode getTextMode() {
        return this.mode;
    }

    public String getIndent() {
        return this.indent;
    }

    public Format setEncoding(String encoding) {
        this.encoding = encoding;
        this.escapeStrategy = Format.chooseStrategy(encoding);
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isSpecifiedAttributesOnly() {
        return this.specifiedAttributesOnly;
    }

    public Format clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return format;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TextMode
    extends Enum<TextMode> {
        public static final /* enum */ TextMode PRESERVE = new TextMode();
        public static final /* enum */ TextMode TRIM = new TextMode();
        public static final /* enum */ TextMode NORMALIZE = new TextMode();
        public static final /* enum */ TextMode TRIM_FULL_WHITE = new TextMode();
        private static final /* synthetic */ TextMode[] $VALUES;

        static {
            $VALUES = new TextMode[]{PRESERVE, TRIM, NORMALIZE, TRIM_FULL_WHITE};
        }
    }

    private static final class DefaultCharsetEscapeStrategy
    implements EscapeStrategy {
        private final CharsetEncoder encoder;

        public DefaultCharsetEscapeStrategy(CharsetEncoder cse) {
            this.encoder = cse;
        }
    }

    private static final class EscapeStrategy7Bits
    implements EscapeStrategy {
        private EscapeStrategy7Bits() {
        }
    }

    private static final class EscapeStrategy8Bits
    implements EscapeStrategy {
        private EscapeStrategy8Bits() {
        }
    }

    private static final class EscapeStrategyUTF
    implements EscapeStrategy {
        private EscapeStrategyUTF() {
        }
    }
}

