/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.wordcount;

import com.whitemagicsoftware.wordcount.Tokenizer;
import com.whitemagicsoftware.wordcount.TokenizerException;
import com.whitemagicsoftware.wordcount.TokenizerImpl;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ko.KoreanAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class TokenizerFactory {
    private static final Map<Locale, Class<? extends Analyzer>> ANALYZERS = Map.of(Locale.ENGLISH, EnglishAnalyzer.class, Locale.CHINESE, SmartChineseAnalyzer.class, Locale.JAPANESE, JapaneseAnalyzer.class, Locale.KOREAN, KoreanAnalyzer.class);

    private TokenizerFactory() {
    }

    public static Tokenizer create(Locale language) throws TokenizerException {
        try {
            Class<StandardAnalyzer> clazz = ANALYZERS.getOrDefault(language, StandardAnalyzer.class);
            return new TokenizerImpl((Analyzer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new TokenizerException(ex);
        }
    }
}

