/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public final class IOUtils {
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private IOUtils() {
    }

    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder));
    }

    public static <T> T requireResourceNonNull(T resource, String name) throws IOException {
        if (resource == null) {
            throw new FileNotFoundException("The resource '" + name + "' was not found.");
        }
        return resource;
    }
}

