/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.DataInputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public abstract class StringHelper {
    public static final int GOOD_FAST_HASH_SEED;
    private static BigInteger nextId;
    private static final BigInteger mask128;
    private static final Object idLock;

    private StringHelper() {
    }

    public static int murmurhash3_x86_32(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i = offset; i < roundedEnd; i += 4) {
            int k1 = BitUtil.VH_LE_INT.get(data, i);
            k1 *= -862048943;
            k1 = Integer.rotateLeft(k1, 15);
            h1 ^= (k1 *= 461845907);
            h1 = Integer.rotateLeft(h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int murmurhash3_x86_32(BytesRef bytes, int seed) {
        return StringHelper.murmurhash3_x86_32(bytes.bytes, bytes.offset, bytes.length, seed);
    }

    static {
        long x1;
        long x0;
        String prop = System.getProperty("tests.seed");
        GOOD_FAST_HASH_SEED = prop != null ? prop.hashCode() : (int)System.currentTimeMillis();
        idLock = new Object();
        byte[] maskBytes128 = new byte[16];
        Arrays.fill(maskBytes128, (byte)-1);
        mask128 = new BigInteger(1, maskBytes128);
        String prop2 = System.getProperty("tests.seed");
        if (prop2 != null) {
            if (prop2.length() > 8) {
                prop2 = prop2.substring(prop2.length() - 8);
            }
            x1 = x0 = Long.parseLong(prop2, 16);
        } else {
            try (DataInputStream is = new DataInputStream(Files.newInputStream(Paths.get("/dev/urandom", new String[0]), new OpenOption[0]));){
                x0 = is.readLong();
                x1 = is.readLong();
            }
            catch (Exception unavailable) {
                x0 = System.nanoTime();
                x1 = (long)StringHelper.class.hashCode() << 32;
                StringBuilder sb = new StringBuilder();
                try {
                    Properties p = System.getProperties();
                    for (String s : p.stringPropertyNames()) {
                        sb.append(s);
                        sb.append(p.getProperty(s));
                    }
                    x1 |= (long)sb.toString().hashCode();
                }
                catch (SecurityException notallowed) {
                    x1 |= (long)StringBuffer.class.hashCode();
                }
            }
        }
        for (int i = 0; i < 10; ++i) {
            long s0;
            long s1 = x0;
            x0 = s0 = x1;
            s1 ^= s1 << 23;
            x1 = s1 ^ s0 ^ s1 >>> 17 ^ s0 >>> 26;
        }
        byte[] maskBytes64 = new byte[8];
        Arrays.fill(maskBytes64, (byte)-1);
        BigInteger mask64 = new BigInteger(1, maskBytes64);
        BigInteger unsignedX0 = BigInteger.valueOf(x0).and(mask64);
        BigInteger unsignedX1 = BigInteger.valueOf(x1).and(mask64);
        nextId = unsignedX0.shiftLeft(64).or(unsignedX1);
    }
}

