/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.Glue;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;

public class GlueSettingsParser {
    private static final String RESOURCE_NAME = "GlueSettings.xml";
    private static final Map<String, Integer> typeMappings = new HashMap<String, Integer>();
    private static final Map<String, Integer> styleMappings = new HashMap<String, Integer>();
    private final Map<String, Integer> glueTypeMappings = new HashMap<String, Integer>();
    private Glue[] glueTypes;
    private final Element root = new XMLResourceReader("GlueSettings.xml").read();

    public GlueSettingsParser() throws ResourceParseException {
        this.parseGlueTypes();
    }

    private void parseGlueTypes() throws ResourceParseException {
        ArrayList<Glue> glueTypesList = new ArrayList<Glue>();
        Element types = this.root.getChild("GlueTypes");
        int defaultIndex = -1;
        int index = 0;
        if (types != null) {
            for (Element type : types.getChildren("GlueType")) {
                String name = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", type);
                Glue glue = this.createGlue(type, name);
                if (name.equalsIgnoreCase("default")) {
                    defaultIndex = index;
                }
                glueTypesList.add(glue);
                ++index;
            }
        }
        if (defaultIndex < 0) {
            defaultIndex = index;
            glueTypesList.add(new Glue(0.0f, 0.0f, 0.0f, "default"));
        }
        this.glueTypes = glueTypesList.toArray(new Glue[0]);
        if (defaultIndex > 0) {
            Glue tmp = this.glueTypes[defaultIndex];
            this.glueTypes[defaultIndex] = this.glueTypes[0];
            this.glueTypes[0] = tmp;
        }
        for (int i = 0; i < this.glueTypes.length; ++i) {
            this.glueTypeMappings.put(this.glueTypes[i].getName(), i);
        }
    }

    private Glue createGlue(Element type, String name) throws ResourceParseException {
        String[] names = new String[]{"space", "stretch", "shrink"};
        float[] values = new float[names.length];
        for (int i = 0; i < names.length; ++i) {
            double val = 0.0;
            String attrVal = null;
            try {
                attrVal = type.getAttributeValue(names[i]);
                if (attrVal != null) {
                    val = Double.parseDouble(attrVal);
                }
            }
            catch (NumberFormatException e) {
                throw new XMLResourceParseException(RESOURCE_NAME, "GlueType", names[i], "has an invalid real value '" + attrVal + "'");
            }
            values[i] = (float)val;
        }
        return new Glue(values[0], values[1], values[2], name);
    }

    public Glue[] getGlueTypes() {
        return this.glueTypes;
    }

    public int[][][] createGlueTable() throws ResourceParseException {
        int size = typeMappings.size();
        int[][][] table = new int[size][size][styleMappings.size()];
        Element glueTable = this.root.getChild("GlueTable");
        if (glueTable != null) {
            for (Element glue : glueTable.getChildren("Glue")) {
                String left = GlueSettingsParser.getAttrValueAndCheckIfNotNull("lefttype", glue);
                String right = GlueSettingsParser.getAttrValueAndCheckIfNotNull("righttype", glue);
                String type = GlueSettingsParser.getAttrValueAndCheckIfNotNull("gluetype", glue);
                for (Element style : glue.getChildren("Style")) {
                    String styleName = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", style);
                    Integer l = typeMappings.get(left);
                    Integer r = typeMappings.get(right);
                    Integer st = styleMappings.get(styleName);
                    Integer val = this.glueTypeMappings.get(type);
                    GlueSettingsParser.checkMapping(l, "Glue", "lefttype", left);
                    GlueSettingsParser.checkMapping(r, "Glue", "righttype", right);
                    GlueSettingsParser.checkMapping(val, "Glue", "gluetype", type);
                    GlueSettingsParser.checkMapping(st, "Style", "name", styleName);
                    table[l.intValue()][r.intValue()][st.intValue()] = val;
                }
            }
        }
        return table;
    }

    private static void checkMapping(Object val, String elementName, String attrName, String attrValue) throws ResourceParseException {
        if (val == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, elementName, attrName, "has an unknown value '" + attrValue + "'");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getName(), attrName, null);
        }
        return attrValue;
    }

    static {
        styleMappings.put("display", 0);
        styleMappings.put("text", 1);
        styleMappings.put("script", 2);
        styleMappings.put("script_script", 3);
        typeMappings.put("ord", 0);
        typeMappings.put("op", 1);
        typeMappings.put("bin", 2);
        typeMappings.put("rel", 3);
        typeMappings.put("open", 4);
        typeMappings.put("close", 5);
        typeMappings.put("punct", 6);
        typeMappings.put("inner", 7);
    }
}

